/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatusListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchDomainsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    public List<ElasticsearchDomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse)((Object)obj);
        return Objects.equals(this.domainStatusList(), other.domainStatusList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticsearchDomainsResponse").add("DomainStatusList", this.domainStatusList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.ofNullable(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            super(model);
            this.domainStatusList(model.domainStatusList);
        }

        public final Collection<ElasticsearchDomainStatus.Builder> getDomainStatusList() {
            return this.domainStatusList != null ? (Collection)this.domainStatusList.stream().map(ElasticsearchDomainStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder> ... domainStatusList) {
            this.domainStatusList(Stream.of(domainStatusList).map(c -> (ElasticsearchDomainStatus)((ElasticsearchDomainStatus.Builder)ElasticsearchDomainStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        public Builder domainStatusList(Collection<ElasticsearchDomainStatus> var1);

        public Builder domainStatusList(ElasticsearchDomainStatus ... var1);

        public Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder> ... var1);
    }
}

