/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.CompatibleVersionsMapMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibleVersionsMap
implements StructuredPojo,
ToCopyableBuilder<Builder, CompatibleVersionsMap> {
    private final String sourceVersion;
    private final List<String> targetVersions;

    private CompatibleVersionsMap(BuilderImpl builder) {
        this.sourceVersion = builder.sourceVersion;
        this.targetVersions = builder.targetVersions;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public List<String> targetVersions() {
        return this.targetVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleVersionsMap)) {
            return false;
        }
        CompatibleVersionsMap other = (CompatibleVersionsMap)obj;
        return Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.targetVersions(), other.targetVersions());
    }

    public String toString() {
        return ToString.builder((String)"CompatibleVersionsMap").add("SourceVersion", (Object)this.sourceVersion()).add("TargetVersions", this.targetVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "TargetVersions": {
                return Optional.ofNullable(clazz.cast(this.targetVersions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompatibleVersionsMapMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceVersion;
        private List<String> targetVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleVersionsMap model) {
            this.sourceVersion(model.sourceVersion);
            this.targetVersions(model.targetVersions);
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final Collection<String> getTargetVersions() {
            return this.targetVersions;
        }

        @Override
        public final Builder targetVersions(Collection<String> targetVersions) {
            this.targetVersions = ElasticsearchVersionListCopier.copy(targetVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVersions(String ... targetVersions) {
            this.targetVersions(Arrays.asList(targetVersions));
            return this;
        }

        public final void setTargetVersions(Collection<String> targetVersions) {
            this.targetVersions = ElasticsearchVersionListCopier.copy(targetVersions);
        }

        public CompatibleVersionsMap build() {
            return new CompatibleVersionsMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompatibleVersionsMap> {
        public Builder sourceVersion(String var1);

        public Builder targetVersions(Collection<String> var1);

        public Builder targetVersions(String ... var1);
    }
}

