/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.CognitoOptionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, CognitoOptions> {
    private final Boolean enabled;
    private final String userPoolId;
    private final String identityPoolId;
    private final String roleArn;

    private CognitoOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.userPoolId = builder.userPoolId;
        this.identityPoolId = builder.identityPoolId;
        this.roleArn = builder.roleArn;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoOptions)) {
            return false;
        }
        CognitoOptions other = (CognitoOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"CognitoOptions").add("Enabled", (Object)this.enabled()).add("UserPoolId", (Object)this.userPoolId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String userPoolId;
        private String identityPoolId;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoOptions model) {
            this.enabled(model.enabled);
            this.userPoolId(model.userPoolId);
            this.identityPoolId(model.identityPoolId);
            this.roleArn(model.roleArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public CognitoOptions build() {
            return new CognitoOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CognitoOptions> {
        public Builder enabled(Boolean var1);

        public Builder userPoolId(String var1);

        public Builder identityPoolId(String var1);

        public Builder roleArn(String var1);
    }
}

