/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.LimitValueListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.AdditionalLimitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, AdditionalLimit> {
    private final String limitName;
    private final List<String> limitValues;

    private AdditionalLimit(BuilderImpl builder) {
        this.limitName = builder.limitName;
        this.limitValues = builder.limitValues;
    }

    public String limitName() {
        return this.limitName;
    }

    public List<String> limitValues() {
        return this.limitValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limitName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalLimit)) {
            return false;
        }
        AdditionalLimit other = (AdditionalLimit)obj;
        return Objects.equals(this.limitName(), other.limitName()) && Objects.equals(this.limitValues(), other.limitValues());
    }

    public String toString() {
        return ToString.builder((String)"AdditionalLimit").add("LimitName", (Object)this.limitName()).add("LimitValues", this.limitValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LimitName": {
                return Optional.ofNullable(clazz.cast(this.limitName()));
            }
            case "LimitValues": {
                return Optional.ofNullable(clazz.cast(this.limitValues()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdditionalLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String limitName;
        private List<String> limitValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalLimit model) {
            this.limitName(model.limitName);
            this.limitValues(model.limitValues);
        }

        public final String getLimitName() {
            return this.limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        public final Collection<String> getLimitValues() {
            return this.limitValues;
        }

        @Override
        public final Builder limitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitValues(String ... limitValues) {
            this.limitValues(Arrays.asList(limitValues));
            return this;
        }

        public final void setLimitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
        }

        public AdditionalLimit build() {
            return new AdditionalLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AdditionalLimit> {
        public Builder limitName(String var1);

        public Builder limitValues(Collection<String> var1);

        public Builder limitValues(String ... var1);
    }
}

