/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchClusterConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DEDICATEDMASTERENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DedicatedMasterEnabled").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ZONEAWARENESSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZoneAwarenessEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> DEDICATEDMASTERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DedicatedMasterType").isBinary(false).build();
    private static final MarshallingInfo<Integer> DEDICATEDMASTERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DedicatedMasterCount").isBinary(false).build();
    private static final ElasticsearchClusterConfigMarshaller INSTANCE = new ElasticsearchClusterConfigMarshaller();

    private ElasticsearchClusterConfigMarshaller() {
    }

    public static ElasticsearchClusterConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchClusterConfig elasticsearchClusterConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchClusterConfig, (String)"elasticsearchClusterConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.instanceTypeAsString(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.dedicatedMasterEnabled(), DEDICATEDMASTERENABLED_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.zoneAwarenessEnabled(), ZONEAWARENESSENABLED_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.dedicatedMasterTypeAsString(), DEDICATEDMASTERTYPE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfig.dedicatedMasterCount(), DEDICATEDMASTERCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

