/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EBSOptionsMarshaller {
    private static final MarshallingInfo<Boolean> EBSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EBSEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").isBinary(false).build();
    private static final MarshallingInfo<Integer> VOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSize").isBinary(false).build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").isBinary(false).build();
    private static final EBSOptionsMarshaller INSTANCE = new EBSOptionsMarshaller();

    private EBSOptionsMarshaller() {
    }

    public static EBSOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EBSOptions ebsOptions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ebsOptions, (String)"ebsOptions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ebsOptions.ebsEnabled(), EBSENABLED_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.volumeTypeAsString(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.volumeSize(), VOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.iops(), IOPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

