/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;

public class ListElasticsearchVersionsPublisher
implements SdkPublisher<ListElasticsearchVersionsResponse> {
    private final ElasticsearchAsyncClient client;
    private final ListElasticsearchVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListElasticsearchVersionsPublisher(ElasticsearchAsyncClient client, ListElasticsearchVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListElasticsearchVersionsPublisher(ElasticsearchAsyncClient client, ListElasticsearchVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListElasticsearchVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListElasticsearchVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListElasticsearchVersionsPublisher resume(ListElasticsearchVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListElasticsearchVersionsPublisher(this.client, (ListElasticsearchVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListElasticsearchVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListElasticsearchVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListElasticsearchVersionsResponseFetcher
    implements AsyncPageFetcher<ListElasticsearchVersionsResponse> {
        private ListElasticsearchVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListElasticsearchVersionsResponse> nextPage(ListElasticsearchVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchVersionsPublisher.this.client.listElasticsearchVersions(ListElasticsearchVersionsPublisher.this.firstRequest);
            }
            return ListElasticsearchVersionsPublisher.this.client.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

