/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.services.elasticsearch.transform.LogPublishingOptionsStatusMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LogPublishingOptionsStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, LogPublishingOptionsStatus> {
    private final Map<String, LogPublishingOption> options;
    private final OptionStatus status;

    private LogPublishingOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public Map<LogType, LogPublishingOption> options() {
        return TypeConverter.convert(this.options, LogType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LogType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, LogPublishingOption> optionsAsStrings() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOptionsStatus)) {
            return false;
        }
        LogPublishingOptionsStatus other = (LogPublishingOptionsStatus)obj;
        return Objects.equals(this.optionsAsStrings(), other.optionsAsStrings()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"LogPublishingOptionsStatus").add("Options", this.optionsAsStrings()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.of(clazz.cast(this.optionsAsStrings()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogPublishingOptionsStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, LogPublishingOption> options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOptionsStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final Map<String, LogPublishingOption.Builder> getOptions() {
            return this.options != null ? CollectionUtils.mapValues(this.options, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder options(Map<String, LogPublishingOption> options) {
            this.options = LogPublishingOptionsCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, LogPublishingOption.BuilderImpl> options) {
            this.options = LogPublishingOptionsCopier.copyFromBuilder(options);
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public LogPublishingOptionsStatus build() {
            return new LogPublishingOptionsStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogPublishingOptionsStatus> {
        public Builder options(Map<String, LogPublishingOption> var1);

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().apply(status)).build());
        }
    }
}

