/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchInstanceTypeLimitsRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
    private final String domainName;
    private final String instanceType;
    private final String elasticsearchVersion;

    private DescribeElasticsearchInstanceTypeLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.instanceType = builder.instanceType;
        this.elasticsearchVersion = builder.elasticsearchVersion;
    }

    public String domainName() {
        return this.domainName;
    }

    public ESPartitionInstanceType instanceType() {
        return ESPartitionInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsRequest)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsRequest other = (DescribeElasticsearchInstanceTypeLimitsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticsearchInstanceTypeLimitsRequest").add("DomainName", (Object)this.domainName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeAsString()));
            }
            case "ElasticsearchVersion": {
                return Optional.of(clazz.cast(this.elasticsearchVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String instanceType;
        private String elasticsearchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.instanceType(model.instanceType);
            this.elasticsearchVersion(model.elasticsearchVersion);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticsearchInstanceTypeLimitsRequest build() {
            return new DescribeElasticsearchInstanceTypeLimitsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsRequest> {
        public Builder domainName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder elasticsearchVersion(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

