/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimitListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.StorageTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageType
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageType> {
    private final String storageTypeName;
    private final String storageSubTypeName;
    private final List<StorageTypeLimit> storageTypeLimits;

    private StorageType(BuilderImpl builder) {
        this.storageTypeName = builder.storageTypeName;
        this.storageSubTypeName = builder.storageSubTypeName;
        this.storageTypeLimits = builder.storageTypeLimits;
    }

    public String storageTypeName() {
        return this.storageTypeName;
    }

    public String storageSubTypeName() {
        return this.storageSubTypeName;
    }

    public List<StorageTypeLimit> storageTypeLimits() {
        return this.storageTypeLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.storageTypeName() == null ? 0 : this.storageTypeName().hashCode());
        hashCode = 31 * hashCode + (this.storageSubTypeName() == null ? 0 : this.storageSubTypeName().hashCode());
        hashCode = 31 * hashCode + (this.storageTypeLimits() == null ? 0 : this.storageTypeLimits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageType)) {
            return false;
        }
        StorageType other = (StorageType)obj;
        if (other.storageTypeName() == null ^ this.storageTypeName() == null) {
            return false;
        }
        if (other.storageTypeName() != null && !other.storageTypeName().equals(this.storageTypeName())) {
            return false;
        }
        if (other.storageSubTypeName() == null ^ this.storageSubTypeName() == null) {
            return false;
        }
        if (other.storageSubTypeName() != null && !other.storageSubTypeName().equals(this.storageSubTypeName())) {
            return false;
        }
        if (other.storageTypeLimits() == null ^ this.storageTypeLimits() == null) {
            return false;
        }
        return other.storageTypeLimits() == null || other.storageTypeLimits().equals(this.storageTypeLimits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storageTypeName() != null) {
            sb.append("StorageTypeName: ").append(this.storageTypeName()).append(",");
        }
        if (this.storageSubTypeName() != null) {
            sb.append("StorageSubTypeName: ").append(this.storageSubTypeName()).append(",");
        }
        if (this.storageTypeLimits() != null) {
            sb.append("StorageTypeLimits: ").append(this.storageTypeLimits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String storageTypeName;
        private String storageSubTypeName;
        private List<StorageTypeLimit> storageTypeLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageType model) {
            this.setStorageTypeName(model.storageTypeName);
            this.setStorageSubTypeName(model.storageSubTypeName);
            this.setStorageTypeLimits(model.storageTypeLimits);
        }

        public final String getStorageTypeName() {
            return this.storageTypeName;
        }

        @Override
        public final Builder storageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
            return this;
        }

        public final void setStorageTypeName(String storageTypeName) {
            this.storageTypeName = storageTypeName;
        }

        public final String getStorageSubTypeName() {
            return this.storageSubTypeName;
        }

        @Override
        public final Builder storageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
            return this;
        }

        public final void setStorageSubTypeName(String storageSubTypeName) {
            this.storageSubTypeName = storageSubTypeName;
        }

        public final Collection<StorageTypeLimit> getStorageTypeLimits() {
            return this.storageTypeLimits;
        }

        @Override
        public final Builder storageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copy(storageTypeLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypeLimits(StorageTypeLimit ... storageTypeLimits) {
            if (this.storageTypeLimits == null) {
                this.storageTypeLimits = new ArrayList<StorageTypeLimit>(storageTypeLimits.length);
            }
            for (StorageTypeLimit e : storageTypeLimits) {
                this.storageTypeLimits.add(e);
            }
            return this;
        }

        public final void setStorageTypeLimits(Collection<StorageTypeLimit> storageTypeLimits) {
            this.storageTypeLimits = StorageTypeLimitListCopier.copy(storageTypeLimits);
        }

        @SafeVarargs
        public final void setStorageTypeLimits(StorageTypeLimit ... storageTypeLimits) {
            if (this.storageTypeLimits == null) {
                this.storageTypeLimits = new ArrayList<StorageTypeLimit>(storageTypeLimits.length);
            }
            for (StorageTypeLimit e : storageTypeLimits) {
                this.storageTypeLimits.add(e);
            }
        }

        public StorageType build() {
            return new StorageType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageType> {
        public Builder storageTypeName(String var1);

        public Builder storageSubTypeName(String var1);

        public Builder storageTypeLimits(Collection<StorageTypeLimit> var1);

        public Builder storageTypeLimits(StorageTypeLimit ... var1);
    }
}

