/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListElasticsearchVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
    private final List<String> elasticsearchVersions;
    private final String nextToken;

    private ListElasticsearchVersionsResponse(BuilderImpl builder) {
        this.elasticsearchVersions = builder.elasticsearchVersions;
        this.nextToken = builder.nextToken;
    }

    public List<String> elasticsearchVersions() {
        return this.elasticsearchVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticsearchVersions() == null ? 0 : this.elasticsearchVersions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchVersionsResponse)) {
            return false;
        }
        ListElasticsearchVersionsResponse other = (ListElasticsearchVersionsResponse)((Object)obj);
        if (other.elasticsearchVersions() == null ^ this.elasticsearchVersions() == null) {
            return false;
        }
        if (other.elasticsearchVersions() != null && !other.elasticsearchVersions().equals(this.elasticsearchVersions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.elasticsearchVersions() != null) {
            sb.append("ElasticsearchVersions: ").append(this.elasticsearchVersions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> elasticsearchVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchVersionsResponse model) {
            this.setElasticsearchVersions(model.elasticsearchVersions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchVersions() {
            return this.elasticsearchVersions;
        }

        @Override
        public final Builder elasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchVersions(String ... elasticsearchVersions) {
            if (this.elasticsearchVersions == null) {
                this.elasticsearchVersions = new ArrayList<String>(elasticsearchVersions.length);
            }
            for (String e : elasticsearchVersions) {
                this.elasticsearchVersions.add(e);
            }
            return this;
        }

        public final void setElasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
        }

        @SafeVarargs
        public final void setElasticsearchVersions(String ... elasticsearchVersions) {
            if (this.elasticsearchVersions == null) {
                this.elasticsearchVersions = new ArrayList<String>(elasticsearchVersions.length);
            }
            for (String e : elasticsearchVersions) {
                this.elasticsearchVersions.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListElasticsearchVersionsResponse build() {
            return new ListElasticsearchVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
        public Builder elasticsearchVersions(Collection<String> var1);

        public Builder elasticsearchVersions(String ... var1);

        public Builder nextToken(String var1);
    }
}

