/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.InstanceCountLimitsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCountLimits
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceCountLimits> {
    private final Integer minimumInstanceCount;
    private final Integer maximumInstanceCount;

    private InstanceCountLimits(BuilderImpl builder) {
        this.minimumInstanceCount = builder.minimumInstanceCount;
        this.maximumInstanceCount = builder.maximumInstanceCount;
    }

    public Integer minimumInstanceCount() {
        return this.minimumInstanceCount;
    }

    public Integer maximumInstanceCount() {
        return this.maximumInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.minimumInstanceCount() == null ? 0 : this.minimumInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.maximumInstanceCount() == null ? 0 : this.maximumInstanceCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCountLimits)) {
            return false;
        }
        InstanceCountLimits other = (InstanceCountLimits)obj;
        if (other.minimumInstanceCount() == null ^ this.minimumInstanceCount() == null) {
            return false;
        }
        if (other.minimumInstanceCount() != null && !other.minimumInstanceCount().equals(this.minimumInstanceCount())) {
            return false;
        }
        if (other.maximumInstanceCount() == null ^ this.maximumInstanceCount() == null) {
            return false;
        }
        return other.maximumInstanceCount() == null || other.maximumInstanceCount().equals(this.maximumInstanceCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minimumInstanceCount() != null) {
            sb.append("MinimumInstanceCount: ").append(this.minimumInstanceCount()).append(",");
        }
        if (this.maximumInstanceCount() != null) {
            sb.append("MaximumInstanceCount: ").append(this.maximumInstanceCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceCountLimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer minimumInstanceCount;
        private Integer maximumInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCountLimits model) {
            this.setMinimumInstanceCount(model.minimumInstanceCount);
            this.setMaximumInstanceCount(model.maximumInstanceCount);
        }

        public final Integer getMinimumInstanceCount() {
            return this.minimumInstanceCount;
        }

        @Override
        public final Builder minimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
            return this;
        }

        public final void setMinimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
        }

        public final Integer getMaximumInstanceCount() {
            return this.maximumInstanceCount;
        }

        @Override
        public final Builder maximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
            return this;
        }

        public final void setMaximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
        }

        public InstanceCountLimits build() {
            return new InstanceCountLimits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCountLimits> {
        public Builder minimumInstanceCount(Integer var1);

        public Builder maximumInstanceCount(Integer var1);
    }
}

