/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchClusterConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchClusterConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchClusterConfig> {
    private final String instanceType;
    private final Integer instanceCount;
    private final Boolean dedicatedMasterEnabled;
    private final Boolean zoneAwarenessEnabled;
    private final String dedicatedMasterType;
    private final Integer dedicatedMasterCount;

    private ElasticsearchClusterConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
        this.dedicatedMasterType = builder.dedicatedMasterType;
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public Boolean dedicatedMasterEnabled() {
        return this.dedicatedMasterEnabled;
    }

    public Boolean zoneAwarenessEnabled() {
        return this.zoneAwarenessEnabled;
    }

    public String dedicatedMasterType() {
        return this.dedicatedMasterType;
    }

    public Integer dedicatedMasterCount() {
        return this.dedicatedMasterCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.dedicatedMasterEnabled() == null ? 0 : this.dedicatedMasterEnabled().hashCode());
        hashCode = 31 * hashCode + (this.zoneAwarenessEnabled() == null ? 0 : this.zoneAwarenessEnabled().hashCode());
        hashCode = 31 * hashCode + (this.dedicatedMasterType() == null ? 0 : this.dedicatedMasterType().hashCode());
        hashCode = 31 * hashCode + (this.dedicatedMasterCount() == null ? 0 : this.dedicatedMasterCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfig)) {
            return false;
        }
        ElasticsearchClusterConfig other = (ElasticsearchClusterConfig)obj;
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.dedicatedMasterEnabled() == null ^ this.dedicatedMasterEnabled() == null) {
            return false;
        }
        if (other.dedicatedMasterEnabled() != null && !other.dedicatedMasterEnabled().equals(this.dedicatedMasterEnabled())) {
            return false;
        }
        if (other.zoneAwarenessEnabled() == null ^ this.zoneAwarenessEnabled() == null) {
            return false;
        }
        if (other.zoneAwarenessEnabled() != null && !other.zoneAwarenessEnabled().equals(this.zoneAwarenessEnabled())) {
            return false;
        }
        if (other.dedicatedMasterType() == null ^ this.dedicatedMasterType() == null) {
            return false;
        }
        if (other.dedicatedMasterType() != null && !other.dedicatedMasterType().equals(this.dedicatedMasterType())) {
            return false;
        }
        if (other.dedicatedMasterCount() == null ^ this.dedicatedMasterCount() == null) {
            return false;
        }
        return other.dedicatedMasterCount() == null || other.dedicatedMasterCount().equals(this.dedicatedMasterCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.dedicatedMasterEnabled() != null) {
            sb.append("DedicatedMasterEnabled: ").append(this.dedicatedMasterEnabled()).append(",");
        }
        if (this.zoneAwarenessEnabled() != null) {
            sb.append("ZoneAwarenessEnabled: ").append(this.zoneAwarenessEnabled()).append(",");
        }
        if (this.dedicatedMasterType() != null) {
            sb.append("DedicatedMasterType: ").append(this.dedicatedMasterType()).append(",");
        }
        if (this.dedicatedMasterCount() != null) {
            sb.append("DedicatedMasterCount: ").append(this.dedicatedMasterCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchClusterConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Boolean dedicatedMasterEnabled;
        private Boolean zoneAwarenessEnabled;
        private String dedicatedMasterType;
        private Integer dedicatedMasterCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfig model) {
            this.setInstanceType(model.instanceType);
            this.setInstanceCount(model.instanceCount);
            this.setDedicatedMasterEnabled(model.dedicatedMasterEnabled);
            this.setZoneAwarenessEnabled(model.zoneAwarenessEnabled);
            this.setDedicatedMasterType(model.dedicatedMasterType);
            this.setDedicatedMasterCount(model.dedicatedMasterCount);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return this.dedicatedMasterEnabled;
        }

        @Override
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return this.zoneAwarenessEnabled;
        }

        @Override
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        public final String getDedicatedMasterType() {
            return this.dedicatedMasterType;
        }

        @Override
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        @Override
        public final Builder dedicatedMasterType(ESPartitionInstanceType dedicatedMasterType) {
            this.dedicatedMasterType(dedicatedMasterType.toString());
            return this;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        public final void setDedicatedMasterType(ESPartitionInstanceType dedicatedMasterType) {
            this.dedicatedMasterType(dedicatedMasterType.toString());
        }

        public final Integer getDedicatedMasterCount() {
            return this.dedicatedMasterCount;
        }

        @Override
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        public ElasticsearchClusterConfig build() {
            return new ElasticsearchClusterConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchClusterConfig> {
        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder dedicatedMasterEnabled(Boolean var1);

        public Builder zoneAwarenessEnabled(Boolean var1);

        public Builder dedicatedMasterType(String var1);

        public Builder dedicatedMasterType(ESPartitionInstanceType var1);

        public Builder dedicatedMasterCount(Integer var1);
    }
}

