/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        this.domainStatusList = builder.domainStatusList;
    }

    public List<ElasticsearchDomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainStatusList() == null ? 0 : this.domainStatusList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse)((Object)obj);
        if (other.domainStatusList() == null ^ this.domainStatusList() == null) {
            return false;
        }
        return other.domainStatusList() == null || other.domainStatusList().equals(this.domainStatusList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainStatusList() != null) {
            sb.append("DomainStatusList: ").append(this.domainStatusList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            this.setDomainStatusList(model.domainStatusList);
        }

        public final Collection<ElasticsearchDomainStatus> getDomainStatusList() {
            return this.domainStatusList;
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus ... domainStatusList) {
            if (this.domainStatusList == null) {
                this.domainStatusList = new ArrayList<ElasticsearchDomainStatus>(domainStatusList.length);
            }
            for (ElasticsearchDomainStatus e : domainStatusList) {
                this.domainStatusList.add(e);
            }
            return this;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
        }

        @SafeVarargs
        public final void setDomainStatusList(ElasticsearchDomainStatus ... domainStatusList) {
            if (this.domainStatusList == null) {
                this.domainStatusList = new ArrayList<ElasticsearchDomainStatus>(domainStatusList.length);
            }
            for (ElasticsearchDomainStatus e : domainStatusList) {
                this.domainStatusList.add(e);
            }
        }

        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        public Builder domainStatusList(Collection<ElasticsearchDomainStatus> var1);

        public Builder domainStatusList(ElasticsearchDomainStatus ... var1);
    }
}

