/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTargetGroupsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeTargetGroupsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTargetGroupsRequest.getter(DescribeTargetGroupsRequest::loadBalancerArn)).setter(DescribeTargetGroupsRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTargetGroupsRequest.getter(DescribeTargetGroupsRequest::targetGroupArns)).setter(DescribeTargetGroupsRequest.setter(Builder::targetGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTargetGroupsRequest.getter(DescribeTargetGroupsRequest::names)).setter(DescribeTargetGroupsRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTargetGroupsRequest.getter(DescribeTargetGroupsRequest::marker)).setter(DescribeTargetGroupsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeTargetGroupsRequest.getter(DescribeTargetGroupsRequest::pageSize)).setter(DescribeTargetGroupsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, TARGET_GROUP_ARNS_FIELD, NAMES_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private final String loadBalancerArn;
    private final List<String> targetGroupArns;
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeTargetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.targetGroupArns = builder.targetGroupArns;
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> targetGroupArns() {
        return this.targetGroupArns;
    }

    public List<String> names() {
        return this.names;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.names());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsRequest)) {
            return false;
        }
        DescribeTargetGroupsRequest other = (DescribeTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.targetGroupArns(), other.targetGroupArns()) && Objects.equals(this.names(), other.names()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTargetGroupsRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("TargetGroupArns", this.targetGroupArns()).add("Names", this.names()).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "TargetGroupArns": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArns()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTargetGroupsRequest, T> g) {
        return obj -> g.apply((DescribeTargetGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> targetGroupArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.targetGroupArns(model.targetGroupArns);
            this.names(model.names);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getTargetGroupArns() {
            return this.targetGroupArns;
        }

        @Override
        public final Builder targetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupArns(String ... targetGroupArns) {
            this.targetGroupArns(Arrays.asList(targetGroupArns));
            return this;
        }

        public final void setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTargetGroupsRequest build() {
            return new DescribeTargetGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTargetGroupsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder targetGroupArns(Collection<String> var1);

        public Builder targetGroupArns(String ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

