/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocation;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse;

public class DescribeTrustStoreRevocationsPublisher
implements SdkPublisher<DescribeTrustStoreRevocationsResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeTrustStoreRevocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrustStoreRevocationsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoreRevocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrustStoreRevocationsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoreRevocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrustStoreRevocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrustStoreRevocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeTrustStoreRevocation> trustStoreRevocations() {
        return this.flatMapIterable(response -> response.trustStoreRevocations());
    }

    private class DescribeTrustStoreRevocationsResponseFetcher
    implements AsyncPageFetcher<DescribeTrustStoreRevocationsResponse> {
        private DescribeTrustStoreRevocationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoreRevocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeTrustStoreRevocationsResponse> nextPage(DescribeTrustStoreRevocationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoreRevocationsPublisher.this.client.describeTrustStoreRevocations(DescribeTrustStoreRevocationsPublisher.this.firstRequest);
            }
            return DescribeTrustStoreRevocationsPublisher.this.client.describeTrustStoreRevocations((DescribeTrustStoreRevocationsRequest)((Object)DescribeTrustStoreRevocationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

