/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaim;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaimsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JwtValidationActionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JwtValidationActionConfig> {
    private static final SdkField<String> JWKS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JwksEndpoint").getter(JwtValidationActionConfig.getter(JwtValidationActionConfig::jwksEndpoint)).setter(JwtValidationActionConfig.setter(Builder::jwksEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksEndpoint").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(JwtValidationActionConfig.getter(JwtValidationActionConfig::issuer)).setter(JwtValidationActionConfig.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<List<JwtValidationActionAdditionalClaim>> ADDITIONAL_CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalClaims").getter(JwtValidationActionConfig.getter(JwtValidationActionConfig::additionalClaims)).setter(JwtValidationActionConfig.setter(Builder::additionalClaims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalClaims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JwtValidationActionAdditionalClaim::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JWKS_ENDPOINT_FIELD, ISSUER_FIELD, ADDITIONAL_CLAIMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JwtValidationActionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jwksEndpoint;
    private final String issuer;
    private final List<JwtValidationActionAdditionalClaim> additionalClaims;

    private JwtValidationActionConfig(BuilderImpl builder) {
        this.jwksEndpoint = builder.jwksEndpoint;
        this.issuer = builder.issuer;
        this.additionalClaims = builder.additionalClaims;
    }

    public final String jwksEndpoint() {
        return this.jwksEndpoint;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final boolean hasAdditionalClaims() {
        return this.additionalClaims != null && !(this.additionalClaims instanceof SdkAutoConstructList);
    }

    public final List<JwtValidationActionAdditionalClaim> additionalClaims() {
        return this.additionalClaims;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jwksEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalClaims() ? this.additionalClaims() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtValidationActionConfig)) {
            return false;
        }
        JwtValidationActionConfig other = (JwtValidationActionConfig)obj;
        return Objects.equals(this.jwksEndpoint(), other.jwksEndpoint()) && Objects.equals(this.issuer(), other.issuer()) && this.hasAdditionalClaims() == other.hasAdditionalClaims() && Objects.equals(this.additionalClaims(), other.additionalClaims());
    }

    public final String toString() {
        return ToString.builder((String)"JwtValidationActionConfig").add("JwksEndpoint", (Object)this.jwksEndpoint()).add("Issuer", (Object)this.issuer()).add("AdditionalClaims", this.hasAdditionalClaims() ? this.additionalClaims() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JwksEndpoint": {
                return Optional.ofNullable(clazz.cast(this.jwksEndpoint()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AdditionalClaims": {
                return Optional.ofNullable(clazz.cast(this.additionalClaims()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JwksEndpoint", JWKS_ENDPOINT_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AdditionalClaims", ADDITIONAL_CLAIMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JwtValidationActionConfig, T> g) {
        return obj -> g.apply((JwtValidationActionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jwksEndpoint;
        private String issuer;
        private List<JwtValidationActionAdditionalClaim> additionalClaims = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JwtValidationActionConfig model) {
            this.jwksEndpoint(model.jwksEndpoint);
            this.issuer(model.issuer);
            this.additionalClaims(model.additionalClaims);
        }

        public final String getJwksEndpoint() {
            return this.jwksEndpoint;
        }

        public final void setJwksEndpoint(String jwksEndpoint) {
            this.jwksEndpoint = jwksEndpoint;
        }

        @Override
        public final Builder jwksEndpoint(String jwksEndpoint) {
            this.jwksEndpoint = jwksEndpoint;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final List<JwtValidationActionAdditionalClaim.Builder> getAdditionalClaims() {
            List<JwtValidationActionAdditionalClaim.Builder> result = JwtValidationActionAdditionalClaimsCopier.copyToBuilder(this.additionalClaims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalClaims(Collection<JwtValidationActionAdditionalClaim.BuilderImpl> additionalClaims) {
            this.additionalClaims = JwtValidationActionAdditionalClaimsCopier.copyFromBuilder(additionalClaims);
        }

        @Override
        public final Builder additionalClaims(Collection<JwtValidationActionAdditionalClaim> additionalClaims) {
            this.additionalClaims = JwtValidationActionAdditionalClaimsCopier.copy(additionalClaims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalClaims(JwtValidationActionAdditionalClaim ... additionalClaims) {
            this.additionalClaims(Arrays.asList(additionalClaims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalClaims(Consumer<JwtValidationActionAdditionalClaim.Builder> ... additionalClaims) {
            this.additionalClaims(Stream.of(additionalClaims).map(c -> (JwtValidationActionAdditionalClaim)((JwtValidationActionAdditionalClaim.Builder)JwtValidationActionAdditionalClaim.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public JwtValidationActionConfig build() {
            return new JwtValidationActionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JwtValidationActionConfig> {
        public Builder jwksEndpoint(String var1);

        public Builder issuer(String var1);

        public Builder additionalClaims(Collection<JwtValidationActionAdditionalClaim> var1);

        public Builder additionalClaims(JwtValidationActionAdditionalClaim ... var1);

        public Builder additionalClaims(Consumer<JwtValidationActionAdditionalClaim.Builder> ... var1);
    }
}

