/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit;

public class DescribeAccountLimitsPublisher
implements SdkPublisher<DescribeAccountLimitsResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeAccountLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAccountLimitsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeAccountLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAccountLimitsPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeAccountLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAccountLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAccountLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Limit> limits() {
        return this.flatMapIterable(response -> response.limits());
    }

    private class DescribeAccountLimitsResponseFetcher
    implements AsyncPageFetcher<DescribeAccountLimitsResponse> {
        private DescribeAccountLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccountLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeAccountLimitsResponse> nextPage(DescribeAccountLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccountLimitsPublisher.this.client.describeAccountLimits(DescribeAccountLimitsPublisher.this.firstRequest);
            }
            return DescribeAccountLimitsPublisher.this.client.describeAccountLimits((DescribeAccountLimitsRequest)((Object)DescribeAccountLimitsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

