/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AnomalyResultEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.MitigationInEffectEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetection> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Result").getter(AnomalyDetection.getter(AnomalyDetection::resultAsString)).setter(AnomalyDetection.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final SdkField<String> MITIGATION_IN_EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MitigationInEffect").getter(AnomalyDetection.getter(AnomalyDetection::mitigationInEffectAsString)).setter(AnomalyDetection.setter(Builder::mitigationInEffect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MitigationInEffect").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, MITIGATION_IN_EFFECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalyDetection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String result;
    private final String mitigationInEffect;

    private AnomalyDetection(BuilderImpl builder) {
        this.result = builder.result;
        this.mitigationInEffect = builder.mitigationInEffect;
    }

    public final AnomalyResultEnum result() {
        return AnomalyResultEnum.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final MitigationInEffectEnum mitigationInEffect() {
        return MitigationInEffectEnum.fromValue(this.mitigationInEffect);
    }

    public final String mitigationInEffectAsString() {
        return this.mitigationInEffect;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mitigationInEffectAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetection)) {
            return false;
        }
        AnomalyDetection other = (AnomalyDetection)obj;
        return Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.mitigationInEffectAsString(), other.mitigationInEffectAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetection").add("Result", (Object)this.resultAsString()).add("MitigationInEffect", (Object)this.mitigationInEffectAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "MitigationInEffect": {
                return Optional.ofNullable(clazz.cast(this.mitigationInEffectAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Result", RESULT_FIELD);
        map.put("MitigationInEffect", MITIGATION_IN_EFFECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetection, T> g) {
        return obj -> g.apply((AnomalyDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String result;
        private String mitigationInEffect;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetection model) {
            this.result(model.result);
            this.mitigationInEffect(model.mitigationInEffect);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(AnomalyResultEnum result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMitigationInEffect() {
            return this.mitigationInEffect;
        }

        public final void setMitigationInEffect(String mitigationInEffect) {
            this.mitigationInEffect = mitigationInEffect;
        }

        @Override
        public final Builder mitigationInEffect(String mitigationInEffect) {
            this.mitigationInEffect = mitigationInEffect;
            return this;
        }

        @Override
        public final Builder mitigationInEffect(MitigationInEffectEnum mitigationInEffect) {
            this.mitigationInEffect(mitigationInEffect == null ? null : mitigationInEffect.toString());
            return this;
        }

        public AnomalyDetection build() {
            return new AnomalyDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetection> {
        public Builder result(String var1);

        public Builder result(AnomalyResultEnum var1);

        public Builder mitigationInEffect(String var1);

        public Builder mitigationInEffect(MitigationInEffectEnum var1);
    }
}

