/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a condition for a rule.
 * </p>
 * <p>
 * Each rule can optionally include up to one of each of the following conditions: <code>http-request-method</code>,
 * <code>host-header</code>, <code>path-pattern</code>, and <code>source-ip</code>. Each rule can also optionally
 * include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code>. Note
 * that the value for a condition can't be empty.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your
 * Application Load Balancers</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleCondition implements SdkPojo, Serializable, ToCopyableBuilder<RuleCondition.Builder, RuleCondition> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Field")
            .getter(getter(RuleCondition::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(RuleCondition::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HostHeaderConditionConfig> HOST_HEADER_CONFIG_FIELD = SdkField
            .<HostHeaderConditionConfig> builder(MarshallingType.SDK_POJO).memberName("HostHeaderConfig")
            .getter(getter(RuleCondition::hostHeaderConfig)).setter(setter(Builder::hostHeaderConfig))
            .constructor(HostHeaderConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostHeaderConfig").build()).build();

    private static final SdkField<PathPatternConditionConfig> PATH_PATTERN_CONFIG_FIELD = SdkField
            .<PathPatternConditionConfig> builder(MarshallingType.SDK_POJO).memberName("PathPatternConfig")
            .getter(getter(RuleCondition::pathPatternConfig)).setter(setter(Builder::pathPatternConfig))
            .constructor(PathPatternConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPatternConfig").build()).build();

    private static final SdkField<HttpHeaderConditionConfig> HTTP_HEADER_CONFIG_FIELD = SdkField
            .<HttpHeaderConditionConfig> builder(MarshallingType.SDK_POJO).memberName("HttpHeaderConfig")
            .getter(getter(RuleCondition::httpHeaderConfig)).setter(setter(Builder::httpHeaderConfig))
            .constructor(HttpHeaderConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpHeaderConfig").build()).build();

    private static final SdkField<QueryStringConditionConfig> QUERY_STRING_CONFIG_FIELD = SdkField
            .<QueryStringConditionConfig> builder(MarshallingType.SDK_POJO).memberName("QueryStringConfig")
            .getter(getter(RuleCondition::queryStringConfig)).setter(setter(Builder::queryStringConfig))
            .constructor(QueryStringConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStringConfig").build()).build();

    private static final SdkField<HttpRequestMethodConditionConfig> HTTP_REQUEST_METHOD_CONFIG_FIELD = SdkField
            .<HttpRequestMethodConditionConfig> builder(MarshallingType.SDK_POJO).memberName("HttpRequestMethodConfig")
            .getter(getter(RuleCondition::httpRequestMethodConfig)).setter(setter(Builder::httpRequestMethodConfig))
            .constructor(HttpRequestMethodConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpRequestMethodConfig").build())
            .build();

    private static final SdkField<SourceIpConditionConfig> SOURCE_IP_CONFIG_FIELD = SdkField
            .<SourceIpConditionConfig> builder(MarshallingType.SDK_POJO).memberName("SourceIpConfig")
            .getter(getter(RuleCondition::sourceIpConfig)).setter(setter(Builder::sourceIpConfig))
            .constructor(SourceIpConditionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()).build();

    private static final SdkField<List<String>> REGEX_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegexValues")
            .getter(getter(RuleCondition::regexValues))
            .setter(setter(Builder::regexValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, VALUES_FIELD,
            HOST_HEADER_CONFIG_FIELD, PATH_PATTERN_CONFIG_FIELD, HTTP_HEADER_CONFIG_FIELD, QUERY_STRING_CONFIG_FIELD,
            HTTP_REQUEST_METHOD_CONFIG_FIELD, SOURCE_IP_CONFIG_FIELD, REGEX_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String field;

    private final List<String> values;

    private final HostHeaderConditionConfig hostHeaderConfig;

    private final PathPatternConditionConfig pathPatternConfig;

    private final HttpHeaderConditionConfig httpHeaderConfig;

    private final QueryStringConditionConfig queryStringConfig;

    private final HttpRequestMethodConditionConfig httpRequestMethodConfig;

    private final SourceIpConditionConfig sourceIpConfig;

    private final List<String> regexValues;

    private RuleCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.values = builder.values;
        this.hostHeaderConfig = builder.hostHeaderConfig;
        this.pathPatternConfig = builder.pathPatternConfig;
        this.httpHeaderConfig = builder.httpHeaderConfig;
        this.queryStringConfig = builder.queryStringConfig;
        this.httpRequestMethodConfig = builder.httpRequestMethodConfig;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.regexValues = builder.regexValues;
    }

    /**
     * <p>
     * The field in the HTTP request. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>http-header</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>http-request-method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-header</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>path-pattern</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>query-string</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-ip</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The field in the HTTP request. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>http-header</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>http-request-method</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-header</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>path-pattern</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>query-string</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-ip</code>
     *         </p>
     *         </li>
     */
    public final String field() {
        return field;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
     * <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns, use
     * <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.
     * </p>
     * <p>
     * If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>, you can
     * specify a single host name (for example, my.example.com) in <code>Values</code>. A host name is case insensitive,
     * can be up to 128 characters in length, and can contain any of the following characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * - .
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>Field</code> is <code>path-pattern</code> and you are not using <code>PathPatternConfig</code>, you can
     * specify a single path pattern (for example, /img/*) in <code>Values</code>. A path pattern is case-sensitive, can
     * be up to 128 characters in length, and can contain any of the following characters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A-Z, a-z, 0-9
     * </p>
     * </li>
     * <li>
     * <p>
     * _ - . $ / ~ " ' @ : +
     * </p>
     * </li>
     * <li>
     * <p>
     * &amp; (using &amp;amp;)
     * </p>
     * </li>
     * <li>
     * <p>
     * * (matches 0 or more characters)
     * </p>
     * </li>
     * <li>
     * <p>
     * ? (matches exactly 1 character)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
     *         <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns, use
     *         <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.</p>
     *         <p>
     *         If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>,
     *         you can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name is
     *         case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         - .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>Field</code> is <code>path-pattern</code> and you are not using <code>PathPatternConfig</code>,
     *         you can specify a single path pattern (for example, /img/*) in <code>Values</code>. A path pattern is
     *         case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A-Z, a-z, 0-9
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _ - . $ / ~ " ' @ : +
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         &amp; (using &amp;amp;)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         * (matches 0 or more characters)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ? (matches exactly 1 character)
     *         </p>
     *         </li>
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * Information for a host header condition. Specify only when <code>Field</code> is <code>host-header</code>.
     * </p>
     * 
     * @return Information for a host header condition. Specify only when <code>Field</code> is <code>host-header</code>
     *         .
     */
    public final HostHeaderConditionConfig hostHeaderConfig() {
        return hostHeaderConfig;
    }

    /**
     * <p>
     * Information for a path pattern condition. Specify only when <code>Field</code> is <code>path-pattern</code>.
     * </p>
     * 
     * @return Information for a path pattern condition. Specify only when <code>Field</code> is
     *         <code>path-pattern</code>.
     */
    public final PathPatternConditionConfig pathPatternConfig() {
        return pathPatternConfig;
    }

    /**
     * <p>
     * Information for an HTTP header condition. Specify only when <code>Field</code> is <code>http-header</code>.
     * </p>
     * 
     * @return Information for an HTTP header condition. Specify only when <code>Field</code> is
     *         <code>http-header</code>.
     */
    public final HttpHeaderConditionConfig httpHeaderConfig() {
        return httpHeaderConfig;
    }

    /**
     * <p>
     * Information for a query string condition. Specify only when <code>Field</code> is <code>query-string</code>.
     * </p>
     * 
     * @return Information for a query string condition. Specify only when <code>Field</code> is
     *         <code>query-string</code>.
     */
    public final QueryStringConditionConfig queryStringConfig() {
        return queryStringConfig;
    }

    /**
     * <p>
     * Information for an HTTP method condition. Specify only when <code>Field</code> is
     * <code>http-request-method</code>.
     * </p>
     * 
     * @return Information for an HTTP method condition. Specify only when <code>Field</code> is
     *         <code>http-request-method</code>.
     */
    public final HttpRequestMethodConditionConfig httpRequestMethodConfig() {
        return httpRequestMethodConfig;
    }

    /**
     * <p>
     * Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.
     * </p>
     * 
     * @return Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.
     */
    public final SourceIpConditionConfig sourceIpConfig() {
        return sourceIpConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegexValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegexValues() {
        return regexValues != null && !(regexValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regular expressions to match against the condition field. The maximum length of each string is 128
     * characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>, or
     * <code>path-pattern</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexValues} method.
     * </p>
     * 
     * @return The regular expressions to match against the condition field. The maximum length of each string is 128
     *         characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>,
     *         or <code>path-pattern</code>.
     */
    public final List<String> regexValues() {
        return regexValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hostHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(pathPatternConfig());
        hashCode = 31 * hashCode + Objects.hashCode(httpHeaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(queryStringConfig());
        hashCode = 31 * hashCode + Objects.hashCode(httpRequestMethodConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexValues() ? regexValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition) obj;
        return Objects.equals(field(), other.field()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(hostHeaderConfig(), other.hostHeaderConfig())
                && Objects.equals(pathPatternConfig(), other.pathPatternConfig())
                && Objects.equals(httpHeaderConfig(), other.httpHeaderConfig())
                && Objects.equals(queryStringConfig(), other.queryStringConfig())
                && Objects.equals(httpRequestMethodConfig(), other.httpRequestMethodConfig())
                && Objects.equals(sourceIpConfig(), other.sourceIpConfig()) && hasRegexValues() == other.hasRegexValues()
                && Objects.equals(regexValues(), other.regexValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleCondition").add("Field", field()).add("Values", hasValues() ? values() : null)
                .add("HostHeaderConfig", hostHeaderConfig()).add("PathPatternConfig", pathPatternConfig())
                .add("HttpHeaderConfig", httpHeaderConfig()).add("QueryStringConfig", queryStringConfig())
                .add("HttpRequestMethodConfig", httpRequestMethodConfig()).add("SourceIpConfig", sourceIpConfig())
                .add("RegexValues", hasRegexValues() ? regexValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "HostHeaderConfig":
            return Optional.ofNullable(clazz.cast(hostHeaderConfig()));
        case "PathPatternConfig":
            return Optional.ofNullable(clazz.cast(pathPatternConfig()));
        case "HttpHeaderConfig":
            return Optional.ofNullable(clazz.cast(httpHeaderConfig()));
        case "QueryStringConfig":
            return Optional.ofNullable(clazz.cast(queryStringConfig()));
        case "HttpRequestMethodConfig":
            return Optional.ofNullable(clazz.cast(httpRequestMethodConfig()));
        case "SourceIpConfig":
            return Optional.ofNullable(clazz.cast(sourceIpConfig()));
        case "RegexValues":
            return Optional.ofNullable(clazz.cast(regexValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Field", FIELD_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("HostHeaderConfig", HOST_HEADER_CONFIG_FIELD);
        map.put("PathPatternConfig", PATH_PATTERN_CONFIG_FIELD);
        map.put("HttpHeaderConfig", HTTP_HEADER_CONFIG_FIELD);
        map.put("QueryStringConfig", QUERY_STRING_CONFIG_FIELD);
        map.put("HttpRequestMethodConfig", HTTP_REQUEST_METHOD_CONFIG_FIELD);
        map.put("SourceIpConfig", SOURCE_IP_CONFIG_FIELD);
        map.put("RegexValues", REGEX_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleCondition> {
        /**
         * <p>
         * The field in the HTTP request. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>http-header</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>http-request-method</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-header</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>path-pattern</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>query-string</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-ip</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param field
         *        The field in the HTTP request. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>http-header</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>http-request-method</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-header</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>path-pattern</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>query-string</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-ip</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
         * <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns, use
         * <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.
         * </p>
         * <p>
         * If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>, you
         * can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name is case
         * insensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>Field</code> is <code>path-pattern</code> and you are not using <code>PathPatternConfig</code>, you
         * can specify a single path pattern (for example, /img/*) in <code>Values</code>. A path pattern is
         * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
         *        <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns,
         *        use <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.</p>
         *        <p>
         *        If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>,
         *        you can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name
         *        is case insensitive, can be up to 128 characters in length, and can contain any of the following
         *        characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>Field</code> is <code>path-pattern</code> and you are not using
         *        <code>PathPatternConfig</code>, you can specify a single path pattern (for example, /img/*) in
         *        <code>Values</code>. A path pattern is case-sensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
         * <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns, use
         * <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.
         * </p>
         * <p>
         * If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>, you
         * can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name is case
         * insensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * - .
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>Field</code> is <code>path-pattern</code> and you are not using <code>PathPatternConfig</code>, you
         * can specify a single path pattern (for example, /img/*) in <code>Values</code>. A path pattern is
         * case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A-Z, a-z, 0-9
         * </p>
         * </li>
         * <li>
         * <p>
         * _ - . $ / ~ " ' @ : +
         * </p>
         * </li>
         * <li>
         * <p>
         * &amp; (using &amp;amp;)
         * </p>
         * </li>
         * <li>
         * <p>
         * * (matches 0 or more characters)
         * </p>
         * </li>
         * <li>
         * <p>
         * ? (matches exactly 1 character)
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The condition value. Specify only when <code>Field</code> is <code>host-header</code> or
         *        <code>path-pattern</code>. Alternatively, to specify multiple host names or multiple path patterns,
         *        use <code>HostHeaderConfig</code> or <code>PathPatternConfig</code>.</p>
         *        <p>
         *        If <code>Field</code> is <code>host-header</code> and you are not using <code>HostHeaderConfig</code>,
         *        you can specify a single host name (for example, my.example.com) in <code>Values</code>. A host name
         *        is case insensitive, can be up to 128 characters in length, and can contain any of the following
         *        characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        - .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>Field</code> is <code>path-pattern</code> and you are not using
         *        <code>PathPatternConfig</code>, you can specify a single path pattern (for example, /img/*) in
         *        <code>Values</code>. A path pattern is case-sensitive, can be up to 128 characters in length, and can
         *        contain any of the following characters.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A-Z, a-z, 0-9
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _ - . $ / ~ " ' @ : +
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        &amp; (using &amp;amp;)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        * (matches 0 or more characters)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ? (matches exactly 1 character)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * Information for a host header condition. Specify only when <code>Field</code> is <code>host-header</code>.
         * </p>
         * 
         * @param hostHeaderConfig
         *        Information for a host header condition. Specify only when <code>Field</code> is
         *        <code>host-header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostHeaderConfig(HostHeaderConditionConfig hostHeaderConfig);

        /**
         * <p>
         * Information for a host header condition. Specify only when <code>Field</code> is <code>host-header</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostHeaderConditionConfig.Builder}
         * avoiding the need to create one manually via {@link HostHeaderConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostHeaderConditionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #hostHeaderConfig(HostHeaderConditionConfig)}.
         * 
         * @param hostHeaderConfig
         *        a consumer that will call methods on {@link HostHeaderConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostHeaderConfig(HostHeaderConditionConfig)
         */
        default Builder hostHeaderConfig(Consumer<HostHeaderConditionConfig.Builder> hostHeaderConfig) {
            return hostHeaderConfig(HostHeaderConditionConfig.builder().applyMutation(hostHeaderConfig).build());
        }

        /**
         * <p>
         * Information for a path pattern condition. Specify only when <code>Field</code> is <code>path-pattern</code>.
         * </p>
         * 
         * @param pathPatternConfig
         *        Information for a path pattern condition. Specify only when <code>Field</code> is
         *        <code>path-pattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPatternConfig(PathPatternConditionConfig pathPatternConfig);

        /**
         * <p>
         * Information for a path pattern condition. Specify only when <code>Field</code> is <code>path-pattern</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathPatternConditionConfig.Builder}
         * avoiding the need to create one manually via {@link PathPatternConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathPatternConditionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #pathPatternConfig(PathPatternConditionConfig)}.
         * 
         * @param pathPatternConfig
         *        a consumer that will call methods on {@link PathPatternConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathPatternConfig(PathPatternConditionConfig)
         */
        default Builder pathPatternConfig(Consumer<PathPatternConditionConfig.Builder> pathPatternConfig) {
            return pathPatternConfig(PathPatternConditionConfig.builder().applyMutation(pathPatternConfig).build());
        }

        /**
         * <p>
         * Information for an HTTP header condition. Specify only when <code>Field</code> is <code>http-header</code>.
         * </p>
         * 
         * @param httpHeaderConfig
         *        Information for an HTTP header condition. Specify only when <code>Field</code> is
         *        <code>http-header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpHeaderConfig(HttpHeaderConditionConfig httpHeaderConfig);

        /**
         * <p>
         * Information for an HTTP header condition. Specify only when <code>Field</code> is <code>http-header</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpHeaderConditionConfig.Builder}
         * avoiding the need to create one manually via {@link HttpHeaderConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpHeaderConditionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #httpHeaderConfig(HttpHeaderConditionConfig)}.
         * 
         * @param httpHeaderConfig
         *        a consumer that will call methods on {@link HttpHeaderConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpHeaderConfig(HttpHeaderConditionConfig)
         */
        default Builder httpHeaderConfig(Consumer<HttpHeaderConditionConfig.Builder> httpHeaderConfig) {
            return httpHeaderConfig(HttpHeaderConditionConfig.builder().applyMutation(httpHeaderConfig).build());
        }

        /**
         * <p>
         * Information for a query string condition. Specify only when <code>Field</code> is <code>query-string</code>.
         * </p>
         * 
         * @param queryStringConfig
         *        Information for a query string condition. Specify only when <code>Field</code> is
         *        <code>query-string</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStringConfig(QueryStringConditionConfig queryStringConfig);

        /**
         * <p>
         * Information for a query string condition. Specify only when <code>Field</code> is <code>query-string</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryStringConditionConfig.Builder}
         * avoiding the need to create one manually via {@link QueryStringConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryStringConditionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #queryStringConfig(QueryStringConditionConfig)}.
         * 
         * @param queryStringConfig
         *        a consumer that will call methods on {@link QueryStringConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryStringConfig(QueryStringConditionConfig)
         */
        default Builder queryStringConfig(Consumer<QueryStringConditionConfig.Builder> queryStringConfig) {
            return queryStringConfig(QueryStringConditionConfig.builder().applyMutation(queryStringConfig).build());
        }

        /**
         * <p>
         * Information for an HTTP method condition. Specify only when <code>Field</code> is
         * <code>http-request-method</code>.
         * </p>
         * 
         * @param httpRequestMethodConfig
         *        Information for an HTTP method condition. Specify only when <code>Field</code> is
         *        <code>http-request-method</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRequestMethodConfig(HttpRequestMethodConditionConfig httpRequestMethodConfig);

        /**
         * <p>
         * Information for an HTTP method condition. Specify only when <code>Field</code> is
         * <code>http-request-method</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpRequestMethodConditionConfig.Builder}
         * avoiding the need to create one manually via {@link HttpRequestMethodConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpRequestMethodConditionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #httpRequestMethodConfig(HttpRequestMethodConditionConfig)}.
         * 
         * @param httpRequestMethodConfig
         *        a consumer that will call methods on {@link HttpRequestMethodConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpRequestMethodConfig(HttpRequestMethodConditionConfig)
         */
        default Builder httpRequestMethodConfig(Consumer<HttpRequestMethodConditionConfig.Builder> httpRequestMethodConfig) {
            return httpRequestMethodConfig(HttpRequestMethodConditionConfig.builder().applyMutation(httpRequestMethodConfig)
                    .build());
        }

        /**
         * <p>
         * Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.
         * </p>
         * 
         * @param sourceIpConfig
         *        Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpConfig(SourceIpConditionConfig sourceIpConfig);

        /**
         * <p>
         * Information for a source IP condition. Specify only when <code>Field</code> is <code>source-ip</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceIpConditionConfig.Builder} avoiding
         * the need to create one manually via {@link SourceIpConditionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceIpConditionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceIpConfig(SourceIpConditionConfig)}.
         * 
         * @param sourceIpConfig
         *        a consumer that will call methods on {@link SourceIpConditionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIpConfig(SourceIpConditionConfig)
         */
        default Builder sourceIpConfig(Consumer<SourceIpConditionConfig.Builder> sourceIpConfig) {
            return sourceIpConfig(SourceIpConditionConfig.builder().applyMutation(sourceIpConfig).build());
        }

        /**
         * <p>
         * The regular expressions to match against the condition field. The maximum length of each string is 128
         * characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>, or
         * <code>path-pattern</code>.
         * </p>
         * 
         * @param regexValues
         *        The regular expressions to match against the condition field. The maximum length of each string is 128
         *        characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>
         *        , or <code>path-pattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexValues(Collection<String> regexValues);

        /**
         * <p>
         * The regular expressions to match against the condition field. The maximum length of each string is 128
         * characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>, or
         * <code>path-pattern</code>.
         * </p>
         * 
         * @param regexValues
         *        The regular expressions to match against the condition field. The maximum length of each string is 128
         *        characters. Specify only when <code>Field</code> is <code>http-header</code>, <code>host-header</code>
         *        , or <code>path-pattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexValues(String... regexValues);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private HostHeaderConditionConfig hostHeaderConfig;

        private PathPatternConditionConfig pathPatternConfig;

        private HttpHeaderConditionConfig httpHeaderConfig;

        private QueryStringConditionConfig queryStringConfig;

        private HttpRequestMethodConditionConfig httpRequestMethodConfig;

        private SourceIpConditionConfig sourceIpConfig;

        private List<String> regexValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            field(model.field);
            values(model.values);
            hostHeaderConfig(model.hostHeaderConfig);
            pathPatternConfig(model.pathPatternConfig);
            httpHeaderConfig(model.httpHeaderConfig);
            queryStringConfig(model.queryStringConfig);
            httpRequestMethodConfig(model.httpRequestMethodConfig);
            sourceIpConfig(model.sourceIpConfig);
            regexValues(model.regexValues);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final HostHeaderConditionConfig.Builder getHostHeaderConfig() {
            return hostHeaderConfig != null ? hostHeaderConfig.toBuilder() : null;
        }

        public final void setHostHeaderConfig(HostHeaderConditionConfig.BuilderImpl hostHeaderConfig) {
            this.hostHeaderConfig = hostHeaderConfig != null ? hostHeaderConfig.build() : null;
        }

        @Override
        public final Builder hostHeaderConfig(HostHeaderConditionConfig hostHeaderConfig) {
            this.hostHeaderConfig = hostHeaderConfig;
            return this;
        }

        public final PathPatternConditionConfig.Builder getPathPatternConfig() {
            return pathPatternConfig != null ? pathPatternConfig.toBuilder() : null;
        }

        public final void setPathPatternConfig(PathPatternConditionConfig.BuilderImpl pathPatternConfig) {
            this.pathPatternConfig = pathPatternConfig != null ? pathPatternConfig.build() : null;
        }

        @Override
        public final Builder pathPatternConfig(PathPatternConditionConfig pathPatternConfig) {
            this.pathPatternConfig = pathPatternConfig;
            return this;
        }

        public final HttpHeaderConditionConfig.Builder getHttpHeaderConfig() {
            return httpHeaderConfig != null ? httpHeaderConfig.toBuilder() : null;
        }

        public final void setHttpHeaderConfig(HttpHeaderConditionConfig.BuilderImpl httpHeaderConfig) {
            this.httpHeaderConfig = httpHeaderConfig != null ? httpHeaderConfig.build() : null;
        }

        @Override
        public final Builder httpHeaderConfig(HttpHeaderConditionConfig httpHeaderConfig) {
            this.httpHeaderConfig = httpHeaderConfig;
            return this;
        }

        public final QueryStringConditionConfig.Builder getQueryStringConfig() {
            return queryStringConfig != null ? queryStringConfig.toBuilder() : null;
        }

        public final void setQueryStringConfig(QueryStringConditionConfig.BuilderImpl queryStringConfig) {
            this.queryStringConfig = queryStringConfig != null ? queryStringConfig.build() : null;
        }

        @Override
        public final Builder queryStringConfig(QueryStringConditionConfig queryStringConfig) {
            this.queryStringConfig = queryStringConfig;
            return this;
        }

        public final HttpRequestMethodConditionConfig.Builder getHttpRequestMethodConfig() {
            return httpRequestMethodConfig != null ? httpRequestMethodConfig.toBuilder() : null;
        }

        public final void setHttpRequestMethodConfig(HttpRequestMethodConditionConfig.BuilderImpl httpRequestMethodConfig) {
            this.httpRequestMethodConfig = httpRequestMethodConfig != null ? httpRequestMethodConfig.build() : null;
        }

        @Override
        public final Builder httpRequestMethodConfig(HttpRequestMethodConditionConfig httpRequestMethodConfig) {
            this.httpRequestMethodConfig = httpRequestMethodConfig;
            return this;
        }

        public final SourceIpConditionConfig.Builder getSourceIpConfig() {
            return sourceIpConfig != null ? sourceIpConfig.toBuilder() : null;
        }

        public final void setSourceIpConfig(SourceIpConditionConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConditionConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final Collection<String> getRegexValues() {
            if (regexValues instanceof SdkAutoConstructList) {
                return null;
            }
            return regexValues;
        }

        public final void setRegexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
        }

        @Override
        public final Builder regexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexValues(String... regexValues) {
            regexValues(Arrays.asList(regexValues));
            return this;
        }

        @Override
        public RuleCondition build() {
            return new RuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
