/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the revocations used by a trust store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustStoreRevocation implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeTrustStoreRevocation.Builder, DescribeTrustStoreRevocation> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(DescribeTrustStoreRevocation::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<Long> REVOCATION_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RevocationId").getter(getter(DescribeTrustStoreRevocation::revocationId))
            .setter(setter(Builder::revocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationId").build()).build();

    private static final SdkField<String> REVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevocationType").getter(getter(DescribeTrustStoreRevocation::revocationTypeAsString))
            .setter(setter(Builder::revocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationType").build()).build();

    private static final SdkField<Long> NUMBER_OF_REVOKED_ENTRIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfRevokedEntries").getter(getter(DescribeTrustStoreRevocation::numberOfRevokedEntries))
            .setter(setter(Builder::numberOfRevokedEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRevokedEntries").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD,
            REVOCATION_ID_FIELD, REVOCATION_TYPE_FIELD, NUMBER_OF_REVOKED_ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustStoreArn;

    private final Long revocationId;

    private final String revocationType;

    private final Long numberOfRevokedEntries;

    private DescribeTrustStoreRevocation(BuilderImpl builder) {
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationId = builder.revocationId;
        this.revocationType = builder.revocationType;
        this.numberOfRevokedEntries = builder.numberOfRevokedEntries;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * The revocation ID of a revocation file in use.
     * </p>
     * 
     * @return The revocation ID of a revocation file in use.
     */
    public final Long revocationId() {
        return revocationId;
    }

    /**
     * <p>
     * The type of revocation file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationType}
     * will return {@link RevocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationTypeAsString}.
     * </p>
     * 
     * @return The type of revocation file.
     * @see RevocationType
     */
    public final RevocationType revocationType() {
        return RevocationType.fromValue(revocationType);
    }

    /**
     * <p>
     * The type of revocation file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationType}
     * will return {@link RevocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationTypeAsString}.
     * </p>
     * 
     * @return The type of revocation file.
     * @see RevocationType
     */
    public final String revocationTypeAsString() {
        return revocationType;
    }

    /**
     * <p>
     * The number of revoked certificates.
     * </p>
     * 
     * @return The number of revoked certificates.
     */
    public final Long numberOfRevokedEntries() {
        return numberOfRevokedEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(revocationId());
        hashCode = 31 * hashCode + Objects.hashCode(revocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRevokedEntries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustStoreRevocation)) {
            return false;
        }
        DescribeTrustStoreRevocation other = (DescribeTrustStoreRevocation) obj;
        return Objects.equals(trustStoreArn(), other.trustStoreArn()) && Objects.equals(revocationId(), other.revocationId())
                && Objects.equals(revocationTypeAsString(), other.revocationTypeAsString())
                && Objects.equals(numberOfRevokedEntries(), other.numberOfRevokedEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrustStoreRevocation").add("TrustStoreArn", trustStoreArn())
                .add("RevocationId", revocationId()).add("RevocationType", revocationTypeAsString())
                .add("NumberOfRevokedEntries", numberOfRevokedEntries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "RevocationId":
            return Optional.ofNullable(clazz.cast(revocationId()));
        case "RevocationType":
            return Optional.ofNullable(clazz.cast(revocationTypeAsString()));
        case "NumberOfRevokedEntries":
            return Optional.ofNullable(clazz.cast(numberOfRevokedEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("RevocationId", REVOCATION_ID_FIELD);
        map.put("RevocationType", REVOCATION_TYPE_FIELD);
        map.put("NumberOfRevokedEntries", NUMBER_OF_REVOKED_ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustStoreRevocation, T> g) {
        return obj -> g.apply((DescribeTrustStoreRevocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeTrustStoreRevocation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The revocation ID of a revocation file in use.
         * </p>
         * 
         * @param revocationId
         *        The revocation ID of a revocation file in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationId(Long revocationId);

        /**
         * <p>
         * The type of revocation file.
         * </p>
         * 
         * @param revocationType
         *        The type of revocation file.
         * @see RevocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationType
         */
        Builder revocationType(String revocationType);

        /**
         * <p>
         * The type of revocation file.
         * </p>
         * 
         * @param revocationType
         *        The type of revocation file.
         * @see RevocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationType
         */
        Builder revocationType(RevocationType revocationType);

        /**
         * <p>
         * The number of revoked certificates.
         * </p>
         * 
         * @param numberOfRevokedEntries
         *        The number of revoked certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRevokedEntries(Long numberOfRevokedEntries);
    }

    static final class BuilderImpl implements Builder {
        private String trustStoreArn;

        private Long revocationId;

        private String revocationType;

        private Long numberOfRevokedEntries;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustStoreRevocation model) {
            trustStoreArn(model.trustStoreArn);
            revocationId(model.revocationId);
            revocationType(model.revocationType);
            numberOfRevokedEntries(model.numberOfRevokedEntries);
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Long getRevocationId() {
            return revocationId;
        }

        public final void setRevocationId(Long revocationId) {
            this.revocationId = revocationId;
        }

        @Override
        public final Builder revocationId(Long revocationId) {
            this.revocationId = revocationId;
            return this;
        }

        public final String getRevocationType() {
            return revocationType;
        }

        public final void setRevocationType(String revocationType) {
            this.revocationType = revocationType;
        }

        @Override
        public final Builder revocationType(String revocationType) {
            this.revocationType = revocationType;
            return this;
        }

        @Override
        public final Builder revocationType(RevocationType revocationType) {
            this.revocationType(revocationType == null ? null : revocationType.toString());
            return this;
        }

        public final Long getNumberOfRevokedEntries() {
            return numberOfRevokedEntries;
        }

        public final void setNumberOfRevokedEntries(Long numberOfRevokedEntries) {
            this.numberOfRevokedEntries = numberOfRevokedEntries;
        }

        @Override
        public final Builder numberOfRevokedEntries(Long numberOfRevokedEntries) {
            this.numberOfRevokedEntries = numberOfRevokedEntries;
            return this;
        }

        @Override
        public DescribeTrustStoreRevocation build() {
            return new DescribeTrustStoreRevocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
