/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityReservationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZonalCapacityReservationState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZonalCapacityReservationState> {
    private static final SdkField<CapacityReservationStatus> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(ZonalCapacityReservationState.getter(ZonalCapacityReservationState::state)).setter(ZonalCapacityReservationState.setter(Builder::state)).constructor(CapacityReservationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ZonalCapacityReservationState.getter(ZonalCapacityReservationState::availabilityZone)).setter(ZonalCapacityReservationState.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Double> EFFECTIVE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EffectiveCapacityUnits").getter(ZonalCapacityReservationState.getter(ZonalCapacityReservationState::effectiveCapacityUnits)).setter(ZonalCapacityReservationState.setter(Builder::effectiveCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, AVAILABILITY_ZONE_FIELD, EFFECTIVE_CAPACITY_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ZonalCapacityReservationState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CapacityReservationStatus state;
    private final String availabilityZone;
    private final Double effectiveCapacityUnits;

    private ZonalCapacityReservationState(BuilderImpl builder) {
        this.state = builder.state;
        this.availabilityZone = builder.availabilityZone;
        this.effectiveCapacityUnits = builder.effectiveCapacityUnits;
    }

    public final CapacityReservationStatus state() {
        return this.state;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Double effectiveCapacityUnits() {
        return this.effectiveCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalCapacityReservationState)) {
            return false;
        }
        ZonalCapacityReservationState other = (ZonalCapacityReservationState)obj;
        return Objects.equals(this.state(), other.state()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.effectiveCapacityUnits(), other.effectiveCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"ZonalCapacityReservationState").add("State", (Object)this.state()).add("AvailabilityZone", (Object)this.availabilityZone()).add("EffectiveCapacityUnits", (Object)this.effectiveCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "EffectiveCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.effectiveCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("EffectiveCapacityUnits", EFFECTIVE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZonalCapacityReservationState, T> g) {
        return obj -> g.apply((ZonalCapacityReservationState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CapacityReservationStatus state;
        private String availabilityZone;
        private Double effectiveCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalCapacityReservationState model) {
            this.state(model.state);
            this.availabilityZone(model.availabilityZone);
            this.effectiveCapacityUnits(model.effectiveCapacityUnits);
        }

        public final CapacityReservationStatus.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(CapacityReservationStatus.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(CapacityReservationStatus state) {
            this.state = state;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Double getEffectiveCapacityUnits() {
            return this.effectiveCapacityUnits;
        }

        public final void setEffectiveCapacityUnits(Double effectiveCapacityUnits) {
            this.effectiveCapacityUnits = effectiveCapacityUnits;
        }

        @Override
        public final Builder effectiveCapacityUnits(Double effectiveCapacityUnits) {
            this.effectiveCapacityUnits = effectiveCapacityUnits;
            return this;
        }

        public ZonalCapacityReservationState build() {
            return new ZonalCapacityReservationState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZonalCapacityReservationState> {
        public Builder state(CapacityReservationStatus var1);

        default public Builder state(Consumer<CapacityReservationStatus.Builder> state) {
            return this.state((CapacityReservationStatus)((CapacityReservationStatus.Builder)CapacityReservationStatus.builder().applyMutation(state)).build());
        }

        public Builder availabilityZone(String var1);

        public Builder effectiveCapacityUnits(Double var1);
    }
}

