/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a transform to apply to requests that match a rule. Transforms are applied to requests before they
 * are sent to targets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleTransform implements SdkPojo, Serializable, ToCopyableBuilder<RuleTransform.Builder, RuleTransform> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RuleTransform::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<HostHeaderRewriteConfig> HOST_HEADER_REWRITE_CONFIG_FIELD = SdkField
            .<HostHeaderRewriteConfig> builder(MarshallingType.SDK_POJO).memberName("HostHeaderRewriteConfig")
            .getter(getter(RuleTransform::hostHeaderRewriteConfig)).setter(setter(Builder::hostHeaderRewriteConfig))
            .constructor(HostHeaderRewriteConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostHeaderRewriteConfig").build())
            .build();

    private static final SdkField<UrlRewriteConfig> URL_REWRITE_CONFIG_FIELD = SdkField
            .<UrlRewriteConfig> builder(MarshallingType.SDK_POJO).memberName("UrlRewriteConfig")
            .getter(getter(RuleTransform::urlRewriteConfig)).setter(setter(Builder::urlRewriteConfig))
            .constructor(UrlRewriteConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlRewriteConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            HOST_HEADER_REWRITE_CONFIG_FIELD, URL_REWRITE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final HostHeaderRewriteConfig hostHeaderRewriteConfig;

    private final UrlRewriteConfig urlRewriteConfig;

    private RuleTransform(BuilderImpl builder) {
        this.type = builder.type;
        this.hostHeaderRewriteConfig = builder.hostHeaderRewriteConfig;
        this.urlRewriteConfig = builder.urlRewriteConfig;
    }

    /**
     * <p>
     * The type of transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>host-header-rewrite</code> - Rewrite the host header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>url-rewrite</code> - Rewrite the request URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TransformTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of transform. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>host-header-rewrite</code> - Rewrite the host header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>url-rewrite</code> - Rewrite the request URL.
     *         </p>
     *         </li>
     * @see TransformTypeEnum
     */
    public final TransformTypeEnum type() {
        return TransformTypeEnum.fromValue(type);
    }

    /**
     * <p>
     * The type of transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>host-header-rewrite</code> - Rewrite the host header.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>url-rewrite</code> - Rewrite the request URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TransformTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of transform. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>host-header-rewrite</code> - Rewrite the host header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>url-rewrite</code> - Rewrite the request URL.
     *         </p>
     *         </li>
     * @see TransformTypeEnum
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about a host header rewrite transform. This transform modifies the host header in an HTTP request.
     * Specify only when <code>Type</code> is <code>host-header-rewrite</code>.
     * </p>
     * 
     * @return Information about a host header rewrite transform. This transform modifies the host header in an HTTP
     *         request. Specify only when <code>Type</code> is <code>host-header-rewrite</code>.
     */
    public final HostHeaderRewriteConfig hostHeaderRewriteConfig() {
        return hostHeaderRewriteConfig;
    }

    /**
     * <p>
     * Information about a URL rewrite transform. This transform modifies the request URL. Specify only when
     * <code>Type</code> is <code>url-rewrite</code>.
     * </p>
     * 
     * @return Information about a URL rewrite transform. This transform modifies the request URL. Specify only when
     *         <code>Type</code> is <code>url-rewrite</code>.
     */
    public final UrlRewriteConfig urlRewriteConfig() {
        return urlRewriteConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostHeaderRewriteConfig());
        hashCode = 31 * hashCode + Objects.hashCode(urlRewriteConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTransform)) {
            return false;
        }
        RuleTransform other = (RuleTransform) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(hostHeaderRewriteConfig(), other.hostHeaderRewriteConfig())
                && Objects.equals(urlRewriteConfig(), other.urlRewriteConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleTransform").add("Type", typeAsString())
                .add("HostHeaderRewriteConfig", hostHeaderRewriteConfig()).add("UrlRewriteConfig", urlRewriteConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "HostHeaderRewriteConfig":
            return Optional.ofNullable(clazz.cast(hostHeaderRewriteConfig()));
        case "UrlRewriteConfig":
            return Optional.ofNullable(clazz.cast(urlRewriteConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("HostHeaderRewriteConfig", HOST_HEADER_REWRITE_CONFIG_FIELD);
        map.put("UrlRewriteConfig", URL_REWRITE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleTransform, T> g) {
        return obj -> g.apply((RuleTransform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleTransform> {
        /**
         * <p>
         * The type of transform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>host-header-rewrite</code> - Rewrite the host header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>url-rewrite</code> - Rewrite the request URL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of transform. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>host-header-rewrite</code> - Rewrite the host header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>url-rewrite</code> - Rewrite the request URL.
         *        </p>
         *        </li>
         * @see TransformTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformTypeEnum
         */
        Builder type(String type);

        /**
         * <p>
         * The type of transform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>host-header-rewrite</code> - Rewrite the host header.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>url-rewrite</code> - Rewrite the request URL.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of transform. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>host-header-rewrite</code> - Rewrite the host header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>url-rewrite</code> - Rewrite the request URL.
         *        </p>
         *        </li>
         * @see TransformTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformTypeEnum
         */
        Builder type(TransformTypeEnum type);

        /**
         * <p>
         * Information about a host header rewrite transform. This transform modifies the host header in an HTTP
         * request. Specify only when <code>Type</code> is <code>host-header-rewrite</code>.
         * </p>
         * 
         * @param hostHeaderRewriteConfig
         *        Information about a host header rewrite transform. This transform modifies the host header in an HTTP
         *        request. Specify only when <code>Type</code> is <code>host-header-rewrite</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostHeaderRewriteConfig(HostHeaderRewriteConfig hostHeaderRewriteConfig);

        /**
         * <p>
         * Information about a host header rewrite transform. This transform modifies the host header in an HTTP
         * request. Specify only when <code>Type</code> is <code>host-header-rewrite</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostHeaderRewriteConfig.Builder} avoiding
         * the need to create one manually via {@link HostHeaderRewriteConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostHeaderRewriteConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #hostHeaderRewriteConfig(HostHeaderRewriteConfig)}.
         * 
         * @param hostHeaderRewriteConfig
         *        a consumer that will call methods on {@link HostHeaderRewriteConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostHeaderRewriteConfig(HostHeaderRewriteConfig)
         */
        default Builder hostHeaderRewriteConfig(Consumer<HostHeaderRewriteConfig.Builder> hostHeaderRewriteConfig) {
            return hostHeaderRewriteConfig(HostHeaderRewriteConfig.builder().applyMutation(hostHeaderRewriteConfig).build());
        }

        /**
         * <p>
         * Information about a URL rewrite transform. This transform modifies the request URL. Specify only when
         * <code>Type</code> is <code>url-rewrite</code>.
         * </p>
         * 
         * @param urlRewriteConfig
         *        Information about a URL rewrite transform. This transform modifies the request URL. Specify only when
         *        <code>Type</code> is <code>url-rewrite</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlRewriteConfig(UrlRewriteConfig urlRewriteConfig);

        /**
         * <p>
         * Information about a URL rewrite transform. This transform modifies the request URL. Specify only when
         * <code>Type</code> is <code>url-rewrite</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlRewriteConfig.Builder} avoiding the
         * need to create one manually via {@link UrlRewriteConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UrlRewriteConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #urlRewriteConfig(UrlRewriteConfig)}.
         * 
         * @param urlRewriteConfig
         *        a consumer that will call methods on {@link UrlRewriteConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlRewriteConfig(UrlRewriteConfig)
         */
        default Builder urlRewriteConfig(Consumer<UrlRewriteConfig.Builder> urlRewriteConfig) {
            return urlRewriteConfig(UrlRewriteConfig.builder().applyMutation(urlRewriteConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private HostHeaderRewriteConfig hostHeaderRewriteConfig;

        private UrlRewriteConfig urlRewriteConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTransform model) {
            type(model.type);
            hostHeaderRewriteConfig(model.hostHeaderRewriteConfig);
            urlRewriteConfig(model.urlRewriteConfig);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TransformTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final HostHeaderRewriteConfig.Builder getHostHeaderRewriteConfig() {
            return hostHeaderRewriteConfig != null ? hostHeaderRewriteConfig.toBuilder() : null;
        }

        public final void setHostHeaderRewriteConfig(HostHeaderRewriteConfig.BuilderImpl hostHeaderRewriteConfig) {
            this.hostHeaderRewriteConfig = hostHeaderRewriteConfig != null ? hostHeaderRewriteConfig.build() : null;
        }

        @Override
        public final Builder hostHeaderRewriteConfig(HostHeaderRewriteConfig hostHeaderRewriteConfig) {
            this.hostHeaderRewriteConfig = hostHeaderRewriteConfig;
            return this;
        }

        public final UrlRewriteConfig.Builder getUrlRewriteConfig() {
            return urlRewriteConfig != null ? urlRewriteConfig.toBuilder() : null;
        }

        public final void setUrlRewriteConfig(UrlRewriteConfig.BuilderImpl urlRewriteConfig) {
            this.urlRewriteConfig = urlRewriteConfig != null ? urlRewriteConfig.build() : null;
        }

        @Override
        public final Builder urlRewriteConfig(UrlRewriteConfig urlRewriteConfig) {
            this.urlRewriteConfig = urlRewriteConfig;
            return this;
        }

        @Override
        public RuleTransform build() {
            return new RuleTransform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
