/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSubnetsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<SetSubnetsResponse.Builder, SetSubnetsResponse> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(SetSubnetsResponse::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(SetSubnetsResponse::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<String> ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnablePrefixForIpv6SourceNat")
            .getter(getter(SetSubnetsResponse::enablePrefixForIpv6SourceNatAsString))
            .setter(setter(Builder::enablePrefixForIpv6SourceNat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrefixForIpv6SourceNat")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            IP_ADDRESS_TYPE_FIELD, ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AvailabilityZone> availabilityZones;

    private final String ipAddressType;

    private final String enablePrefixForIpv6SourceNat;

    private SetSubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.ipAddressType = builder.ipAddressType;
        this.enablePrefixForIpv6SourceNat = builder.enablePrefixForIpv6SourceNat;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return Information about the subnets.
     */
    public final List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The IP address type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enablePrefixForIpv6SourceNat} will return {@link EnablePrefixForIpv6SourceNatEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #enablePrefixForIpv6SourceNatAsString}.
     * </p>
     * 
     * @return [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
     * @see EnablePrefixForIpv6SourceNatEnum
     */
    public final EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat() {
        return EnablePrefixForIpv6SourceNatEnum.fromValue(enablePrefixForIpv6SourceNat);
    }

    /**
     * <p>
     * [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enablePrefixForIpv6SourceNat} will return {@link EnablePrefixForIpv6SourceNatEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #enablePrefixForIpv6SourceNatAsString}.
     * </p>
     * 
     * @return [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
     * @see EnablePrefixForIpv6SourceNatEnum
     */
    public final String enablePrefixForIpv6SourceNatAsString() {
        return enablePrefixForIpv6SourceNat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enablePrefixForIpv6SourceNatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsResponse)) {
            return false;
        }
        SetSubnetsResponse other = (SetSubnetsResponse) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(enablePrefixForIpv6SourceNatAsString(), other.enablePrefixForIpv6SourceNatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetSubnetsResponse")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("IpAddressType", ipAddressTypeAsString())
                .add("EnablePrefixForIpv6SourceNat", enablePrefixForIpv6SourceNatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "EnablePrefixForIpv6SourceNat":
            return Optional.ofNullable(clazz.cast(enablePrefixForIpv6SourceNatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("EnablePrefixForIpv6SourceNat", ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetSubnetsResponse, T> g) {
        return obj -> g.apply((SetSubnetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, SetSubnetsResponse> {
        /**
         * <p>
         * Information about the subnets.
         * </p>
         * 
         * @param availabilityZones
         *        Information about the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * Information about the subnets.
         * </p>
         * 
         * @param availabilityZones
         *        Information about the subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * Information about the subnets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone.Builder#build()} is
         * called immediately and its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(java.util.Collection<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The IP address type.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
         * </p>
         * 
         * @param enablePrefixForIpv6SourceNat
         *        [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
         * @see EnablePrefixForIpv6SourceNatEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablePrefixForIpv6SourceNatEnum
         */
        Builder enablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat);

        /**
         * <p>
         * [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
         * </p>
         * 
         * @param enablePrefixForIpv6SourceNat
         *        [Network Load Balancers] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
         * @see EnablePrefixForIpv6SourceNatEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablePrefixForIpv6SourceNatEnum
         */
        Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private String enablePrefixForIpv6SourceNat;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsResponse model) {
            super(model);
            availabilityZones(model.availabilityZones);
            ipAddressType(model.ipAddressType);
            enablePrefixForIpv6SourceNat(model.enablePrefixForIpv6SourceNat);
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getEnablePrefixForIpv6SourceNat() {
            return enablePrefixForIpv6SourceNat;
        }

        public final void setEnablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
            return this;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat(enablePrefixForIpv6SourceNat == null ? null : enablePrefixForIpv6SourceNat
                    .toString());
            return this;
        }

        @Override
        public SetSubnetsResponse build() {
            return new SetSubnetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
