/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZoneName").getter(getter(AvailabilityZone::zoneName)).setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AvailabilityZone::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(AvailabilityZone::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<List<LoadBalancerAddress>> LOAD_BALANCER_ADDRESSES_FIELD = SdkField
            .<List<LoadBalancerAddress>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerAddresses")
            .getter(getter(AvailabilityZone::loadBalancerAddresses))
            .setter(setter(Builder::loadBalancerAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_NAT_IPV6_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceNatIpv6Prefixes")
            .getter(getter(AvailabilityZone::sourceNatIpv6Prefixes))
            .setter(setter(Builder::sourceNatIpv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceNatIpv6Prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_NAME_FIELD,
            SUBNET_ID_FIELD, OUTPOST_ID_FIELD, LOAD_BALANCER_ADDRESSES_FIELD, SOURCE_NAT_IPV6_PREFIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String zoneName;

    private final String subnetId;

    private final String outpostId;

    private final List<LoadBalancerAddress> loadBalancerAddresses;

    private final List<String> sourceNatIpv6Prefixes;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.subnetId = builder.subnetId;
        this.outpostId = builder.outpostId;
        this.loadBalancerAddresses = builder.loadBalancerAddresses;
        this.sourceNatIpv6Prefixes = builder.sourceNatIpv6Prefixes;
    }

    /**
     * <p>
     * The name of the Availability Zone.
     * </p>
     * 
     * @return The name of the Availability Zone.
     */
    public final String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The ID of the subnet. You can specify one subnet per Availability Zone.
     * </p>
     * 
     * @return The ID of the subnet. You can specify one subnet per Availability Zone.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * [Application Load Balancers on Outposts] The ID of the Outpost.
     * </p>
     * 
     * @return [Application Load Balancers on Outposts] The ID of the Outpost.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerAddresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLoadBalancerAddresses() {
        return loadBalancerAddresses != null && !(loadBalancerAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic IP
     * address per Availability Zone when you create an internal-facing load balancer. For internal load balancers, you
     * can specify a private IP address from the IPv4 range of the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerAddresses} method.
     * </p>
     * 
     * @return [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
     *         Elastic IP address per Availability Zone when you create an internal-facing load balancer. For internal
     *         load balancers, you can specify a private IP address from the IPv4 range of the subnet.
     */
    public final List<LoadBalancerAddress> loadBalancerAddresses() {
        return loadBalancerAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceNatIpv6Prefixes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceNatIpv6Prefixes() {
        return sourceNatIpv6Prefixes != null && !(sourceNatIpv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet, specify an
     * IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use an IPv6 prefix selected
     * at random from the subnet CIDR block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceNatIpv6Prefixes} method.
     * </p>
     * 
     * @return [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet,
     *         specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use an
     *         IPv6 prefix selected at random from the subnet CIDR block.
     */
    public final List<String> sourceNatIpv6Prefixes() {
        return sourceNatIpv6Prefixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerAddresses() ? loadBalancerAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceNatIpv6Prefixes() ? sourceNatIpv6Prefixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(zoneName(), other.zoneName()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(outpostId(), other.outpostId())
                && hasLoadBalancerAddresses() == other.hasLoadBalancerAddresses()
                && Objects.equals(loadBalancerAddresses(), other.loadBalancerAddresses())
                && hasSourceNatIpv6Prefixes() == other.hasSourceNatIpv6Prefixes()
                && Objects.equals(sourceNatIpv6Prefixes(), other.sourceNatIpv6Prefixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityZone").add("ZoneName", zoneName()).add("SubnetId", subnetId())
                .add("OutpostId", outpostId())
                .add("LoadBalancerAddresses", hasLoadBalancerAddresses() ? loadBalancerAddresses() : null)
                .add("SourceNatIpv6Prefixes", hasSourceNatIpv6Prefixes() ? sourceNatIpv6Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "LoadBalancerAddresses":
            return Optional.ofNullable(clazz.cast(loadBalancerAddresses()));
        case "SourceNatIpv6Prefixes":
            return Optional.ofNullable(clazz.cast(sourceNatIpv6Prefixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ZoneName", ZONE_NAME_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("LoadBalancerAddresses", LOAD_BALANCER_ADDRESSES_FIELD);
        map.put("SourceNatIpv6Prefixes", SOURCE_NAT_IPV6_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The ID of the subnet. You can specify one subnet per Availability Zone.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet. You can specify one subnet per Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [Application Load Balancers on Outposts] The ID of the Outpost.
         * </p>
         * 
         * @param outpostId
         *        [Application Load Balancers on Outposts] The ID of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * 
         * @param loadBalancerAddresses
         *        [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
         *        Elastic IP address per Availability Zone when you create an internal-facing load balancer. For
         *        internal load balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAddresses(Collection<LoadBalancerAddress> loadBalancerAddresses);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * 
         * @param loadBalancerAddresses
         *        [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
         *        Elastic IP address per Availability Zone when you create an internal-facing load balancer. For
         *        internal load balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAddresses(LoadBalancerAddress... loadBalancerAddresses);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress.Builder#build()} is
         * called immediately and its result is passed to {@link #loadBalancerAddresses(List<LoadBalancerAddress>)}.
         * 
         * @param loadBalancerAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAddresses(java.util.Collection<LoadBalancerAddress>)
         */
        Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder>... loadBalancerAddresses);

        /**
         * <p>
         * [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet, specify
         * an IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use an IPv6 prefix
         * selected at random from the subnet CIDR block.
         * </p>
         * 
         * @param sourceNatIpv6Prefixes
         *        [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet,
         *        specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use
         *        an IPv6 prefix selected at random from the subnet CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNatIpv6Prefixes(Collection<String> sourceNatIpv6Prefixes);

        /**
         * <p>
         * [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet, specify
         * an IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use an IPv6 prefix
         * selected at random from the subnet CIDR block.
         * </p>
         * 
         * @param sourceNatIpv6Prefixes
         *        [Network Load Balancers with UDP listeners] The IPv6 prefixes to use for source NAT. For each subnet,
         *        specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or <code>auto_assigned</code> to use
         *        an IPv6 prefix selected at random from the subnet CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNatIpv6Prefixes(String... sourceNatIpv6Prefixes);
    }

    static final class BuilderImpl implements Builder {
        private String zoneName;

        private String subnetId;

        private String outpostId;

        private List<LoadBalancerAddress> loadBalancerAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceNatIpv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            zoneName(model.zoneName);
            subnetId(model.subnetId);
            outpostId(model.outpostId);
            loadBalancerAddresses(model.loadBalancerAddresses);
            sourceNatIpv6Prefixes(model.sourceNatIpv6Prefixes);
        }

        public final String getZoneName() {
            return zoneName;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final List<LoadBalancerAddress.Builder> getLoadBalancerAddresses() {
            List<LoadBalancerAddress.Builder> result = LoadBalancerAddressesCopier.copyToBuilder(this.loadBalancerAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerAddresses(Collection<LoadBalancerAddress.BuilderImpl> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copyFromBuilder(loadBalancerAddresses);
        }

        @Override
        public final Builder loadBalancerAddresses(Collection<LoadBalancerAddress> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copy(loadBalancerAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(LoadBalancerAddress... loadBalancerAddresses) {
            loadBalancerAddresses(Arrays.asList(loadBalancerAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder>... loadBalancerAddresses) {
            loadBalancerAddresses(Stream.of(loadBalancerAddresses)
                    .map(c -> LoadBalancerAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSourceNatIpv6Prefixes() {
            if (sourceNatIpv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceNatIpv6Prefixes;
        }

        public final void setSourceNatIpv6Prefixes(Collection<String> sourceNatIpv6Prefixes) {
            this.sourceNatIpv6Prefixes = SourceNatIpv6PrefixesCopier.copy(sourceNatIpv6Prefixes);
        }

        @Override
        public final Builder sourceNatIpv6Prefixes(Collection<String> sourceNatIpv6Prefixes) {
            this.sourceNatIpv6Prefixes = SourceNatIpv6PrefixesCopier.copy(sourceNatIpv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceNatIpv6Prefixes(String... sourceNatIpv6Prefixes) {
            sourceNatIpv6Prefixes(Arrays.asList(sourceNatIpv6Prefixes));
            return this;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
