/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTrustStoreRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, ModifyTrustStoreRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(ModifyTrustStoreRequest.getter(ModifyTrustStoreRequest::trustStoreArn)).setter(ModifyTrustStoreRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3Bucket").getter(ModifyTrustStoreRequest.getter(ModifyTrustStoreRequest::caCertificatesBundleS3Bucket)).setter(ModifyTrustStoreRequest.setter(Builder::caCertificatesBundleS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Bucket").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3Key").getter(ModifyTrustStoreRequest.getter(ModifyTrustStoreRequest::caCertificatesBundleS3Key)).setter(ModifyTrustStoreRequest.setter(Builder::caCertificatesBundleS3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Key").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3ObjectVersion").getter(ModifyTrustStoreRequest.getter(ModifyTrustStoreRequest::caCertificatesBundleS3ObjectVersion)).setter(ModifyTrustStoreRequest.setter(Builder::caCertificatesBundleS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3ObjectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD, CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD, CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
            this.put("CaCertificatesBundleS3Bucket", CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD);
            this.put("CaCertificatesBundleS3Key", CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD);
            this.put("CaCertificatesBundleS3ObjectVersion", CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD);
        }
    });
    private final String trustStoreArn;
    private final String caCertificatesBundleS3Bucket;
    private final String caCertificatesBundleS3Key;
    private final String caCertificatesBundleS3ObjectVersion;

    private ModifyTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.caCertificatesBundleS3Bucket = builder.caCertificatesBundleS3Bucket;
        this.caCertificatesBundleS3Key = builder.caCertificatesBundleS3Key;
        this.caCertificatesBundleS3ObjectVersion = builder.caCertificatesBundleS3ObjectVersion;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final String caCertificatesBundleS3Bucket() {
        return this.caCertificatesBundleS3Bucket;
    }

    public final String caCertificatesBundleS3Key() {
        return this.caCertificatesBundleS3Key;
    }

    public final String caCertificatesBundleS3ObjectVersion() {
        return this.caCertificatesBundleS3ObjectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3ObjectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrustStoreRequest)) {
            return false;
        }
        ModifyTrustStoreRequest other = (ModifyTrustStoreRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.caCertificatesBundleS3Bucket(), other.caCertificatesBundleS3Bucket()) && Objects.equals(this.caCertificatesBundleS3Key(), other.caCertificatesBundleS3Key()) && Objects.equals(this.caCertificatesBundleS3ObjectVersion(), other.caCertificatesBundleS3ObjectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTrustStoreRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("CaCertificatesBundleS3Bucket", (Object)this.caCertificatesBundleS3Bucket()).add("CaCertificatesBundleS3Key", (Object)this.caCertificatesBundleS3Key()).add("CaCertificatesBundleS3ObjectVersion", (Object)this.caCertificatesBundleS3ObjectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "CaCertificatesBundleS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3Bucket()));
            }
            case "CaCertificatesBundleS3Key": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3Key()));
            }
            case "CaCertificatesBundleS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3ObjectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrustStoreRequest, T> g) {
        return obj -> g.apply((ModifyTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private String caCertificatesBundleS3Bucket;
        private String caCertificatesBundleS3Key;
        private String caCertificatesBundleS3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrustStoreRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.caCertificatesBundleS3Bucket(model.caCertificatesBundleS3Bucket);
            this.caCertificatesBundleS3Key(model.caCertificatesBundleS3Key);
            this.caCertificatesBundleS3ObjectVersion(model.caCertificatesBundleS3ObjectVersion);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getCaCertificatesBundleS3Bucket() {
            return this.caCertificatesBundleS3Bucket;
        }

        public final void setCaCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
        }

        @Override
        public final Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
            return this;
        }

        public final String getCaCertificatesBundleS3Key() {
            return this.caCertificatesBundleS3Key;
        }

        public final void setCaCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
        }

        @Override
        public final Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
            return this;
        }

        public final String getCaCertificatesBundleS3ObjectVersion() {
            return this.caCertificatesBundleS3ObjectVersion;
        }

        public final void setCaCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
        }

        @Override
        public final Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrustStoreRequest build() {
            return new ModifyTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTrustStoreRequest> {
        public Builder trustStoreArn(String var1);

        public Builder caCertificatesBundleS3Bucket(String var1);

        public Builder caCertificatesBundleS3Key(String var1);

        public Builder caCertificatesBundleS3ObjectVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

