/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionAuthenticationRequestExtraParamsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConditionalBehaviorEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticateOidcActionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticateOidcActionConfig> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::issuer)).setter(AuthenticateOidcActionConfig.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::authorizationEndpoint)).setter(AuthenticateOidcActionConfig.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenEndpoint").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::tokenEndpoint)).setter(AuthenticateOidcActionConfig.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()}).build();
    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInfoEndpoint").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::userInfoEndpoint)).setter(AuthenticateOidcActionConfig.setter(Builder::userInfoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::clientId)).setter(AuthenticateOidcActionConfig.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSecret").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::clientSecret)).setter(AuthenticateOidcActionConfig.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()}).build();
    private static final SdkField<String> SESSION_COOKIE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionCookieName").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::sessionCookieName)).setter(AuthenticateOidcActionConfig.setter(Builder::sessionCookieName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCookieName").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::scope)).setter(AuthenticateOidcActionConfig.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<Long> SESSION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SessionTimeout").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::sessionTimeout)).setter(AuthenticateOidcActionConfig.setter(Builder::sessionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()}).build();
    private static final SdkField<Map<String, String>> AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AuthenticationRequestExtraParams").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::authenticationRequestExtraParams)).setter(AuthenticateOidcActionConfig.setter(Builder::authenticationRequestExtraParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationRequestExtraParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ON_UNAUTHENTICATED_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnUnauthenticatedRequest").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::onUnauthenticatedRequestAsString)).setter(AuthenticateOidcActionConfig.setter(Builder::onUnauthenticatedRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUnauthenticatedRequest").build()}).build();
    private static final SdkField<Boolean> USE_EXISTING_CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseExistingClientSecret").getter(AuthenticateOidcActionConfig.getter(AuthenticateOidcActionConfig::useExistingClientSecret)).setter(AuthenticateOidcActionConfig.setter(Builder::useExistingClientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseExistingClientSecret").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, SESSION_COOKIE_NAME_FIELD, SCOPE_FIELD, SESSION_TIMEOUT_FIELD, AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD, ON_UNAUTHENTICATED_REQUEST_FIELD, USE_EXISTING_CLIENT_SECRET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Issuer", ISSUER_FIELD);
            this.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
            this.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
            this.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
            this.put("ClientId", CLIENT_ID_FIELD);
            this.put("ClientSecret", CLIENT_SECRET_FIELD);
            this.put("SessionCookieName", SESSION_COOKIE_NAME_FIELD);
            this.put("Scope", SCOPE_FIELD);
            this.put("SessionTimeout", SESSION_TIMEOUT_FIELD);
            this.put("AuthenticationRequestExtraParams", AUTHENTICATION_REQUEST_EXTRA_PARAMS_FIELD);
            this.put("OnUnauthenticatedRequest", ON_UNAUTHENTICATED_REQUEST_FIELD);
            this.put("UseExistingClientSecret", USE_EXISTING_CLIENT_SECRET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final String sessionCookieName;
    private final String scope;
    private final Long sessionTimeout;
    private final Map<String, String> authenticationRequestExtraParams;
    private final String onUnauthenticatedRequest;
    private final Boolean useExistingClientSecret;

    private AuthenticateOidcActionConfig(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.sessionCookieName = builder.sessionCookieName;
        this.scope = builder.scope;
        this.sessionTimeout = builder.sessionTimeout;
        this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
        this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
        this.useExistingClientSecret = builder.useExistingClientSecret;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String userInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String sessionCookieName() {
        return this.sessionCookieName;
    }

    public final String scope() {
        return this.scope;
    }

    public final Long sessionTimeout() {
        return this.sessionTimeout;
    }

    public final boolean hasAuthenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams != null && !(this.authenticationRequestExtraParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> authenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams;
    }

    public final AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest() {
        return AuthenticateOidcActionConditionalBehaviorEnum.fromValue(this.onUnauthenticatedRequest);
    }

    public final String onUnauthenticatedRequestAsString() {
        return this.onUnauthenticatedRequest;
    }

    public final Boolean useExistingClientSecret() {
        return this.useExistingClientSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionCookieName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationRequestExtraParams() ? this.authenticationRequestExtraParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onUnauthenticatedRequestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useExistingClientSecret());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticateOidcActionConfig)) {
            return false;
        }
        AuthenticateOidcActionConfig other = (AuthenticateOidcActionConfig)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.sessionCookieName(), other.sessionCookieName()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout()) && this.hasAuthenticationRequestExtraParams() == other.hasAuthenticationRequestExtraParams() && Objects.equals(this.authenticationRequestExtraParams(), other.authenticationRequestExtraParams()) && Objects.equals(this.onUnauthenticatedRequestAsString(), other.onUnauthenticatedRequestAsString()) && Objects.equals(this.useExistingClientSecret(), other.useExistingClientSecret());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticateOidcActionConfig").add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserInfoEndpoint", (Object)this.userInfoEndpoint()).add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)this.clientSecret()).add("SessionCookieName", (Object)this.sessionCookieName()).add("Scope", (Object)this.scope()).add("SessionTimeout", (Object)this.sessionTimeout()).add("AuthenticationRequestExtraParams", this.hasAuthenticationRequestExtraParams() ? this.authenticationRequestExtraParams() : null).add("OnUnauthenticatedRequest", (Object)this.onUnauthenticatedRequestAsString()).add("UseExistingClientSecret", (Object)this.useExistingClientSecret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "UserInfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userInfoEndpoint()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "SessionCookieName": {
                return Optional.ofNullable(clazz.cast(this.sessionCookieName()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "SessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
            case "AuthenticationRequestExtraParams": {
                return Optional.ofNullable(clazz.cast(this.authenticationRequestExtraParams()));
            }
            case "OnUnauthenticatedRequest": {
                return Optional.ofNullable(clazz.cast(this.onUnauthenticatedRequestAsString()));
            }
            case "UseExistingClientSecret": {
                return Optional.ofNullable(clazz.cast(this.useExistingClientSecret()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticateOidcActionConfig, T> g) {
        return obj -> g.apply((AuthenticateOidcActionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private String clientId;
        private String clientSecret;
        private String sessionCookieName;
        private String scope;
        private Long sessionTimeout;
        private Map<String, String> authenticationRequestExtraParams = DefaultSdkAutoConstructMap.getInstance();
        private String onUnauthenticatedRequest;
        private Boolean useExistingClientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticateOidcActionConfig model) {
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userInfoEndpoint(model.userInfoEndpoint);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.sessionCookieName(model.sessionCookieName);
            this.scope(model.scope);
            this.sessionTimeout(model.sessionTimeout);
            this.authenticationRequestExtraParams(model.authenticationRequestExtraParams);
            this.onUnauthenticatedRequest(model.onUnauthenticatedRequest);
            this.useExistingClientSecret(model.useExistingClientSecret);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public final void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        @Override
        public final Builder sessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Long getSessionTimeout() {
            return this.sessionTimeout;
        }

        public final void setSessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final Map<String, String> getAuthenticationRequestExtraParams() {
            if (this.authenticationRequestExtraParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.authenticationRequestExtraParams;
        }

        public final void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
        }

        @Override
        public final Builder authenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = AuthenticateOidcActionAuthenticationRequestExtraParamsCopier.copy(authenticationRequestExtraParams);
            return this;
        }

        public final String getOnUnauthenticatedRequest() {
            return this.onUnauthenticatedRequest;
        }

        public final void setOnUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
        }

        @Override
        public final Builder onUnauthenticatedRequest(String onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest = onUnauthenticatedRequest;
            return this;
        }

        @Override
        public final Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum onUnauthenticatedRequest) {
            this.onUnauthenticatedRequest(onUnauthenticatedRequest == null ? null : onUnauthenticatedRequest.toString());
            return this;
        }

        public final Boolean getUseExistingClientSecret() {
            return this.useExistingClientSecret;
        }

        public final void setUseExistingClientSecret(Boolean useExistingClientSecret) {
            this.useExistingClientSecret = useExistingClientSecret;
        }

        @Override
        public final Builder useExistingClientSecret(Boolean useExistingClientSecret) {
            this.useExistingClientSecret = useExistingClientSecret;
            return this;
        }

        public AuthenticateOidcActionConfig build() {
            return new AuthenticateOidcActionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticateOidcActionConfig> {
        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder userInfoEndpoint(String var1);

        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder sessionCookieName(String var1);

        public Builder scope(String var1);

        public Builder sessionTimeout(Long var1);

        public Builder authenticationRequestExtraParams(Map<String, String> var1);

        public Builder onUnauthenticatedRequest(String var1);

        public Builder onUnauthenticatedRequest(AuthenticateOidcActionConditionalBehaviorEnum var1);

        public Builder useExistingClientSecret(Boolean var1);
    }
}

