/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2AsyncWaiter;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticLoadBalancingV2AsyncWaiter
implements ElasticLoadBalancingV2AsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ElasticLoadBalancingV2AsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeLoadBalancersResponse> loadBalancerExistsWaiter;
    private final AsyncWaiter<DescribeLoadBalancersResponse> loadBalancerAvailableWaiter;
    private final AsyncWaiter<DescribeLoadBalancersResponse> loadBalancersDeletedWaiter;
    private final AsyncWaiter<DescribeTargetHealthResponse> targetInServiceWaiter;
    private final AsyncWaiter<DescribeTargetHealthResponse> targetDeregisteredWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultElasticLoadBalancingV2AsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticLoadBalancingV2AsyncClient)ElasticLoadBalancingV2AsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.loadBalancerExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerExistsWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.loadBalancerAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerAvailableWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.loadBalancersDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeLoadBalancersResponse.class).acceptors(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancersDeletedWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancersDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.targetInServiceWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTargetHealthResponse.class).acceptors(DefaultElasticLoadBalancingV2AsyncWaiter.targetInServiceWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2AsyncWaiter.targetInServiceWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.targetDeregisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTargetHealthResponse.class).acceptors(DefaultElasticLoadBalancingV2AsyncWaiter.targetDeregisteredWaiterAcceptors())).overrideConfiguration(DefaultElasticLoadBalancingV2AsyncWaiter.targetDeregisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancerAvailableWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancerAvailableWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancerExistsWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancerExistsWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancerExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        return this.loadBalancersDeletedWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.loadBalancersDeletedWaiter.runAsync(() -> this.client.describeLoadBalancers(this.applyWaitersUserAgent(describeLoadBalancersRequest)), DefaultElasticLoadBalancingV2AsyncWaiter.loadBalancersDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest) {
        return this.targetDeregisteredWaiter.runAsync(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.targetDeregisteredWaiter.runAsync(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)), DefaultElasticLoadBalancingV2AsyncWaiter.targetDeregisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest) {
        return this.targetInServiceWaiter.runAsync(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.targetInServiceWaiter.runAsync(() -> this.client.describeTargetHealth(this.applyWaitersUserAgent(describeTargetHealthRequest)), DefaultElasticLoadBalancingV2AsyncWaiter.targetInServiceWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancerExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2AsyncWaiter.errorCode(error), "LoadBalancerNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancerAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "active"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "provisioning"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2AsyncWaiter.errorCode(error), "LoadBalancerNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLoadBalancersResponse>> loadBalancersDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLoadBalancersResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("LoadBalancers").flatten().field("State").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "active"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2AsyncWaiter.errorCode(error), "LoadBalancerNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTargetHealthResponse>> targetInServiceWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("TargetHealthDescriptions").flatten().field("TargetHealth").field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "healthy"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2AsyncWaiter.errorCode(error), "InvalidInstance")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTargetHealthResponse>> targetDeregisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTargetHealthResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultElasticLoadBalancingV2AsyncWaiter.errorCode(error), "InvalidTarget")));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("TargetHealthDescriptions").flatten().field("TargetHealth").field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "unused"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration loadBalancerExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration loadBalancerAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration loadBalancersDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration targetInServiceWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration targetDeregisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticLoadBalancingV2AsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticLoadBalancingV2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticLoadBalancingV2AsyncWaiter.Builder {
        private ElasticLoadBalancingV2AsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ElasticLoadBalancingV2AsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ElasticLoadBalancingV2AsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticLoadBalancingV2AsyncWaiter.Builder client(ElasticLoadBalancingV2AsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticLoadBalancingV2AsyncWaiter build() {
            return new DefaultElasticLoadBalancingV2AsyncWaiter(this);
        }
    }
}

