/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancingv2.DefaultElasticLoadBalancingV2BaseClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.DefaultElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancingv2.endpoints.ElasticLoadBalancingV2EndpointProvider;

@SdkInternalApi
final class DefaultElasticLoadBalancingV2ClientBuilder
extends DefaultElasticLoadBalancingV2BaseClientBuilder<ElasticLoadBalancingV2ClientBuilder, ElasticLoadBalancingV2Client>
implements ElasticLoadBalancingV2ClientBuilder {
    DefaultElasticLoadBalancingV2ClientBuilder() {
    }

    @Override
    public DefaultElasticLoadBalancingV2ClientBuilder endpointProvider(ElasticLoadBalancingV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticLoadBalancingV2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElasticLoadBalancingV2ClientBuilder.validateClientOptions(clientConfiguration);
        ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticLoadBalancingV2Client client = new DefaultElasticLoadBalancingV2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticLoadBalancingV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticLoadBalancingV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

