/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetGroup> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupArn").getter(TargetGroup.getter(TargetGroup::targetGroupArn)).setter(TargetGroup.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupArn").build()}).build();
    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupName").getter(TargetGroup.getter(TargetGroup::targetGroupName)).setter(TargetGroup.setter(Builder::targetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TargetGroup.getter(TargetGroup::protocolAsString)).setter(TargetGroup.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(TargetGroup.getter(TargetGroup::port)).setter(TargetGroup.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(TargetGroup.getter(TargetGroup::vpcId)).setter(TargetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckProtocol").getter(TargetGroup.getter(TargetGroup::healthCheckProtocolAsString)).setter(TargetGroup.setter(Builder::healthCheckProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckPort").getter(TargetGroup.getter(TargetGroup::healthCheckPort)).setter(TargetGroup.setter(Builder::healthCheckPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()}).build();
    private static final SdkField<Boolean> HEALTH_CHECK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HealthCheckEnabled").getter(TargetGroup.getter(TargetGroup::healthCheckEnabled)).setter(TargetGroup.setter(Builder::healthCheckEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckEnabled").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckIntervalSeconds").getter(TargetGroup.getter(TargetGroup::healthCheckIntervalSeconds)).setter(TargetGroup.setter(Builder::healthCheckIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckTimeoutSeconds").getter(TargetGroup.getter(TargetGroup::healthCheckTimeoutSeconds)).setter(TargetGroup.setter(Builder::healthCheckTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> HEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthyThresholdCount").getter(TargetGroup.getter(TargetGroup::healthyThresholdCount)).setter(TargetGroup.setter(Builder::healthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThresholdCount").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyThresholdCount").getter(TargetGroup.getter(TargetGroup::unhealthyThresholdCount)).setter(TargetGroup.setter(Builder::unhealthyThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThresholdCount").build()}).build();
    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckPath").getter(TargetGroup.getter(TargetGroup::healthCheckPath)).setter(TargetGroup.setter(Builder::healthCheckPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()}).build();
    private static final SdkField<Matcher> MATCHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matcher").getter(TargetGroup.getter(TargetGroup::matcher)).setter(TargetGroup.setter(Builder::matcher)).constructor(Matcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matcher").build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerArns").getter(TargetGroup.getter(TargetGroup::loadBalancerArns)).setter(TargetGroup.setter(Builder::loadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(TargetGroup.getter(TargetGroup::targetTypeAsString)).setter(TargetGroup.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtocolVersion").getter(TargetGroup.getter(TargetGroup::protocolVersion)).setter(TargetGroup.setter(Builder::protocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD, TARGET_GROUP_NAME_FIELD, PROTOCOL_FIELD, PORT_FIELD, VPC_ID_FIELD, HEALTH_CHECK_PROTOCOL_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_ENABLED_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, HEALTH_CHECK_TIMEOUT_SECONDS_FIELD, HEALTHY_THRESHOLD_COUNT_FIELD, UNHEALTHY_THRESHOLD_COUNT_FIELD, HEALTH_CHECK_PATH_FIELD, MATCHER_FIELD, LOAD_BALANCER_ARNS_FIELD, TARGET_TYPE_FIELD, PROTOCOL_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetGroupArn;
    private final String targetGroupName;
    private final String protocol;
    private final Integer port;
    private final String vpcId;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final Boolean healthCheckEnabled;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final String healthCheckPath;
    private final Matcher matcher;
    private final List<String> loadBalancerArns;
    private final String targetType;
    private final String protocolVersion;

    private TargetGroup(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targetGroupName = builder.targetGroupName;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckEnabled = builder.healthCheckEnabled;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.healthCheckPath = builder.healthCheckPath;
        this.matcher = builder.matcher;
        this.loadBalancerArns = builder.loadBalancerArns;
        this.targetType = builder.targetType;
        this.protocolVersion = builder.protocolVersion;
    }

    public final String targetGroupArn() {
        return this.targetGroupArn;
    }

    public final String targetGroupName() {
        return this.targetGroupName;
    }

    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public final String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public final String healthCheckPort() {
        return this.healthCheckPort;
    }

    public final Boolean healthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public final Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public final Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public final Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public final Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public final String healthCheckPath() {
        return this.healthCheckPath;
    }

    public final Matcher matcher() {
        return this.matcher;
    }

    public final boolean hasLoadBalancerArns() {
        return this.loadBalancerArns != null && !(this.loadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> loadBalancerArns() {
        return this.loadBalancerArns;
    }

    public final TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String protocolVersion() {
        return this.protocolVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerArns() ? this.loadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroup)) {
            return false;
        }
        TargetGroup other = (TargetGroup)obj;
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.targetGroupName(), other.targetGroupName()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckEnabled(), other.healthCheckEnabled()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.matcher(), other.matcher()) && this.hasLoadBalancerArns() == other.hasLoadBalancerArns() && Objects.equals(this.loadBalancerArns(), other.loadBalancerArns()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.protocolVersion(), other.protocolVersion());
    }

    public final String toString() {
        return ToString.builder((String)"TargetGroup").add("TargetGroupArn", (Object)this.targetGroupArn()).add("TargetGroupName", (Object)this.targetGroupName()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckEnabled", (Object)this.healthCheckEnabled()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("Matcher", (Object)this.matcher()).add("LoadBalancerArns", this.hasLoadBalancerArns() ? this.loadBalancerArns() : null).add("TargetType", (Object)this.targetTypeAsString()).add("ProtocolVersion", (Object)this.protocolVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "TargetGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetGroupName()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "HealthCheckProtocol": {
                return Optional.ofNullable(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckEnabled": {
                return Optional.ofNullable(clazz.cast(this.healthCheckEnabled()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "HealthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "Matcher": {
                return Optional.ofNullable(clazz.cast(this.matcher()));
            }
            case "LoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArns()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "ProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.protocolVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroup, T> g) {
        return obj -> g.apply((TargetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String targetGroupName;
        private String protocol;
        private Integer port;
        private String vpcId;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private Boolean healthCheckEnabled;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private String healthCheckPath;
        private Matcher matcher;
        private List<String> loadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private String targetType;
        private String protocolVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroup model) {
            this.targetGroupArn(model.targetGroupArn);
            this.targetGroupName(model.targetGroupName);
            this.protocol(model.protocol);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckEnabled(model.healthCheckEnabled);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.healthCheckPath(model.healthCheckPath);
            this.matcher(model.matcher);
            this.loadBalancerArns(model.loadBalancerArns);
            this.targetType(model.targetType);
            this.protocolVersion(model.protocolVersion);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Boolean getHealthCheckEnabled() {
            return this.healthCheckEnabled;
        }

        @Override
        public final Builder healthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
            return this;
        }

        public final void setHealthCheckEnabled(Boolean healthCheckEnabled) {
            this.healthCheckEnabled = healthCheckEnabled;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final Collection<String> getLoadBalancerArns() {
            if (this.loadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerArns;
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public TargetGroup build() {
            return new TargetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetGroup> {
        public Builder targetGroupArn(String var1);

        public Builder targetGroupName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckEnabled(Boolean var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder healthCheckPath(String var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().applyMutation(matcher)).build());
        }

        public Builder loadBalancerArns(Collection<String> var1);

        public Builder loadBalancerArns(String ... var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetTypeEnum var1);

        public Builder protocolVersion(String var1);
    }
}

