/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy used for SSL negotiation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SslPolicy implements SdkPojo, Serializable, ToCopyableBuilder<SslPolicy.Builder, SslPolicy> {
    private static final SdkField<List<String>> SSL_PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SslProtocols")
            .getter(getter(SslPolicy::sslProtocols))
            .setter(setter(Builder::sslProtocols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProtocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Cipher>> CIPHERS_FIELD = SdkField
            .<List<Cipher>> builder(MarshallingType.LIST)
            .memberName("Ciphers")
            .getter(getter(SslPolicy::ciphers))
            .setter(setter(Builder::ciphers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ciphers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cipher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cipher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SslPolicy::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSL_PROTOCOLS_FIELD,
            CIPHERS_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> sslProtocols;

    private final List<Cipher> ciphers;

    private final String name;

    private SslPolicy(BuilderImpl builder) {
        this.sslProtocols = builder.sslProtocols;
        this.ciphers = builder.ciphers;
        this.name = builder.name;
    }

    /**
     * Returns true if the SslProtocols property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSslProtocols() {
        return sslProtocols != null && !(sslProtocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSslProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The protocols.
     */
    public final List<String> sslProtocols() {
        return sslProtocols;
    }

    /**
     * Returns true if the Ciphers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCiphers() {
        return ciphers != null && !(ciphers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ciphers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCiphers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ciphers.
     */
    public final List<Cipher> ciphers() {
        return ciphers;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSslProtocols() ? sslProtocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCiphers() ? ciphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy) obj;
        return hasSslProtocols() == other.hasSslProtocols() && Objects.equals(sslProtocols(), other.sslProtocols())
                && hasCiphers() == other.hasCiphers() && Objects.equals(ciphers(), other.ciphers())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SslPolicy").add("SslProtocols", hasSslProtocols() ? sslProtocols() : null)
                .add("Ciphers", hasCiphers() ? ciphers() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SslProtocols":
            return Optional.ofNullable(clazz.cast(sslProtocols()));
        case "Ciphers":
            return Optional.ofNullable(clazz.cast(ciphers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SslPolicy, T> g) {
        return obj -> g.apply((SslPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SslPolicy> {
        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param sslProtocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProtocols(Collection<String> sslProtocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param sslProtocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProtocols(String... sslProtocols);

        /**
         * <p>
         * The ciphers.
         * </p>
         * 
         * @param ciphers
         *        The ciphers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphers(Collection<Cipher> ciphers);

        /**
         * <p>
         * The ciphers.
         * </p>
         * 
         * @param ciphers
         *        The ciphers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ciphers(Cipher... ciphers);

        /**
         * <p>
         * The ciphers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cipher>.Builder} avoiding the need to
         * create one manually via {@link List<Cipher>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cipher>.Builder#build()} is called immediately and its
         * result is passed to {@link #ciphers(List<Cipher>)}.
         * 
         * @param ciphers
         *        a consumer that will call methods on {@link List<Cipher>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ciphers(List<Cipher>)
         */
        Builder ciphers(Consumer<Cipher.Builder>... ciphers);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param name
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private List<String> sslProtocols = DefaultSdkAutoConstructList.getInstance();

        private List<Cipher> ciphers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SslPolicy model) {
            sslProtocols(model.sslProtocols);
            ciphers(model.ciphers);
            name(model.name);
        }

        public final Collection<String> getSslProtocols() {
            if (sslProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return sslProtocols;
        }

        @Override
        public final Builder sslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslProtocols(String... sslProtocols) {
            sslProtocols(Arrays.asList(sslProtocols));
            return this;
        }

        public final void setSslProtocols(Collection<String> sslProtocols) {
            this.sslProtocols = SslProtocolsCopier.copy(sslProtocols);
        }

        public final Collection<Cipher.Builder> getCiphers() {
            if (ciphers instanceof SdkAutoConstructList) {
                return null;
            }
            return ciphers != null ? ciphers.stream().map(Cipher::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ciphers(Collection<Cipher> ciphers) {
            this.ciphers = CiphersCopier.copy(ciphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Cipher... ciphers) {
            ciphers(Arrays.asList(ciphers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ciphers(Consumer<Cipher.Builder>... ciphers) {
            ciphers(Stream.of(ciphers).map(c -> Cipher.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCiphers(Collection<Cipher.BuilderImpl> ciphers) {
            this.ciphers = CiphersCopier.copyFromBuilder(ciphers);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public SslPolicy build() {
            return new SslPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
