/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a static IP address for a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerAddress implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerAddress.Builder, LoadBalancerAddress> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerAddress::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerAddress::allocationId)).setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()).build();

    private static final SdkField<String> PRIVATE_IP_V4_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerAddress::privateIPv4Address)).setter(setter(Builder::privateIPv4Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPv4Address").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            ALLOCATION_ID_FIELD, PRIVATE_IP_V4_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String allocationId;

    private final String privateIPv4Address;

    private LoadBalancerAddress(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.allocationId = builder.allocationId;
        this.privateIPv4Address = builder.privateIPv4Address;
    }

    /**
     * <p>
     * The static IP address.
     * </p>
     * 
     * @return The static IP address.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * [Network Load Balancers] The allocation ID of the Elastic IP address for an internal-facing load balancer.
     * </p>
     * 
     * @return [Network Load Balancers] The allocation ID of the Elastic IP address for an internal-facing load
     *         balancer.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * [Network Load Balancers] The private IPv4 address for an internal load balancer.
     * </p>
     * 
     * @return [Network Load Balancers] The private IPv4 address for an internal load balancer.
     */
    public String privateIPv4Address() {
        return privateIPv4Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIPv4Address());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAddress)) {
            return false;
        }
        LoadBalancerAddress other = (LoadBalancerAddress) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(privateIPv4Address(), other.privateIPv4Address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadBalancerAddress").add("IpAddress", ipAddress()).add("AllocationId", allocationId())
                .add("PrivateIPv4Address", privateIPv4Address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PrivateIPv4Address":
            return Optional.ofNullable(clazz.cast(privateIPv4Address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerAddress, T> g) {
        return obj -> g.apply((LoadBalancerAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerAddress> {
        /**
         * <p>
         * The static IP address.
         * </p>
         * 
         * @param ipAddress
         *        The static IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * [Network Load Balancers] The allocation ID of the Elastic IP address for an internal-facing load balancer.
         * </p>
         * 
         * @param allocationId
         *        [Network Load Balancers] The allocation ID of the Elastic IP address for an internal-facing load
         *        balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * [Network Load Balancers] The private IPv4 address for an internal load balancer.
         * </p>
         * 
         * @param privateIPv4Address
         *        [Network Load Balancers] The private IPv4 address for an internal load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIPv4Address(String privateIPv4Address);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String allocationId;

        private String privateIPv4Address;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAddress model) {
            ipAddress(model.ipAddress);
            allocationId(model.allocationId);
            privateIPv4Address(model.privateIPv4Address);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPrivateIPv4Address() {
            return privateIPv4Address;
        }

        @Override
        public final Builder privateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
            return this;
        }

        public final void setPrivateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
        }

        @Override
        public LoadBalancerAddress build() {
            return new LoadBalancerAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
