/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountLimitsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField
            .<List<Limit>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAccountLimitsResponse::limits))
            .setter(setter(Builder::limits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Limit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Limit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAccountLimitsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<Limit> limits;

    private final String nextMarker;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limits = builder.limits;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the Limits property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLimits() {
        return limits != null && !(limits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the limits.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the limits.
     */
    public List<Limit> limits() {
        return limits;
    }

    /**
     * <p>
     * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     * </p>
     * 
     * @return If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        return Objects.equals(limits(), other.limits()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAccountLimitsResponse").add("Limits", limits()).add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * Information about the limits.
         * </p>
         * 
         * @param limits
         *        Information about the limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Collection<Limit> limits);

        /**
         * <p>
         * Information about the limits.
         * </p>
         * 
         * @param limits
         *        Information about the limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(Limit... limits);

        /**
         * <p>
         * Information about the limits.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Limit>.Builder} avoiding the need to create
         * one manually via {@link List<Limit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Limit>.Builder#build()} is called immediately and its result
         * is passed to {@link #limits(List<Limit>)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link List<Limit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(List<Limit>)
         */
        Builder limits(Consumer<Limit.Builder>... limits);

        /**
         * <p>
         * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
         * </p>
         * 
         * @param nextMarker
         *        If there are additional results, this is the marker for the next set of results. Otherwise, this is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            limits(model.limits);
            nextMarker(model.nextMarker);
        }

        public final Collection<Limit.Builder> getLimits() {
            return limits != null ? limits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit... limits) {
            limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder>... limits) {
            limits(Stream.of(limits).map(c -> Limit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
