/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetMapping> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubnetMapping.getter(SubnetMapping::subnetId)).setter(SubnetMapping.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubnetMapping.getter(SubnetMapping::allocationId)).setter(SubnetMapping.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_V4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubnetMapping.getter(SubnetMapping::privateIPv4Address)).setter(SubnetMapping.setter(Builder::privateIPv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPv4Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, ALLOCATION_ID_FIELD, PRIVATE_IP_V4_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final String allocationId;
    private final String privateIPv4Address;

    private SubnetMapping(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.allocationId = builder.allocationId;
        this.privateIPv4Address = builder.privateIPv4Address;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String privateIPv4Address() {
        return this.privateIPv4Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIPv4Address());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetMapping)) {
            return false;
        }
        SubnetMapping other = (SubnetMapping)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.privateIPv4Address(), other.privateIPv4Address());
    }

    public String toString() {
        return ToString.builder((String)"SubnetMapping").add("SubnetId", (Object)this.subnetId()).add("AllocationId", (Object)this.allocationId()).add("PrivateIPv4Address", (Object)this.privateIPv4Address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PrivateIPv4Address": {
                return Optional.ofNullable(clazz.cast(this.privateIPv4Address()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetMapping, T> g) {
        return obj -> g.apply((SubnetMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String allocationId;
        private String privateIPv4Address;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetMapping model) {
            this.subnetId(model.subnetId);
            this.allocationId(model.allocationId);
            this.privateIPv4Address(model.privateIPv4Address);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPrivateIPv4Address() {
            return this.privateIPv4Address;
        }

        @Override
        public final Builder privateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
            return this;
        }

        public final void setPrivateIPv4Address(String privateIPv4Address) {
            this.privateIPv4Address = privateIPv4Address;
        }

        public SubnetMapping build() {
            return new SubnetMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetMapping> {
        public Builder subnetId(String var1);

        public Builder allocationId(String var1);

        public Builder privateIPv4Address(String var1);
    }
}

