/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information to use when checking for a successful response from a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Matcher implements SdkPojo, Serializable, ToCopyableBuilder<Matcher.Builder, Matcher> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Matcher::httpCode)).setter(setter(Builder::httpCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpCode;

    private Matcher(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
    }

    /**
     * <p>
     * The HTTP codes.
     * </p>
     * <p>
     * For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You can
     * specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
     * </p>
     * <p>
     * For Network Load Balancers, this is 200–399.
     * </p>
     * 
     * @return The HTTP codes.</p>
     *         <p>
     *         For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200.
     *         You can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
     *         </p>
     *         <p>
     *         For Network Load Balancers, this is 200–399.
     */
    public String httpCode() {
        return httpCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher) obj;
        return Objects.equals(httpCode(), other.httpCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Matcher").add("HttpCode", httpCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpCode":
            return Optional.ofNullable(clazz.cast(httpCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Matcher, T> g) {
        return obj -> g.apply((Matcher) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Matcher> {
        /**
         * <p>
         * The HTTP codes.
         * </p>
         * <p>
         * For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You
         * can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
         * </p>
         * <p>
         * For Network Load Balancers, this is 200–399.
         * </p>
         * 
         * @param httpCode
         *        The HTTP codes.</p>
         *        <p>
         *        For Application Load Balancers, you can specify values between 200 and 499, and the default value is
         *        200. You can specify multiple values (for example, "200,202") or a range of values (for example,
         *        "200-299").
         *        </p>
         *        <p>
         *        For Network Load Balancers, this is 200–399.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode(String httpCode);
    }

    static final class BuilderImpl implements Builder {
        private String httpCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Matcher model) {
            httpCode(model.httpCode);
        }

        public final String getHttpCode() {
            return httpCode;
        }

        @Override
        public final Builder httpCode(String httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public final void setHttpCode(String httpCode) {
            this.httpCode = httpCode;
        }

        @Override
        public Matcher build() {
            return new Matcher(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
