/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateListenerRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, CreateListenerRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateListenerRequest.getter(CreateListenerRequest::loadBalancerArn)).setter(CreateListenerRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateListenerRequest.getter(CreateListenerRequest::protocolAsString)).setter(CreateListenerRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateListenerRequest.getter(CreateListenerRequest::port)).setter(CreateListenerRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateListenerRequest.getter(CreateListenerRequest::sslPolicy)).setter(CreateListenerRequest.setter(Builder::sslPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()}).build();
    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateListenerRequest.getter(CreateListenerRequest::certificates)).setter(CreateListenerRequest.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateListenerRequest.getter(CreateListenerRequest::defaultActions)).setter(CreateListenerRequest.setter(Builder::defaultActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, PROTOCOL_FIELD, PORT_FIELD, SSL_POLICY_FIELD, CERTIFICATES_FIELD, DEFAULT_ACTIONS_FIELD));
    private final String loadBalancerArn;
    private final String protocol;
    private final Integer port;
    private final String sslPolicy;
    private final List<Certificate> certificates;
    private final List<Action> defaultActions;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String sslPolicy() {
        return this.sslPolicy;
    }

    public boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public List<Certificate> certificates() {
        return this.certificates;
    }

    public boolean hasDefaultActions() {
        return this.defaultActions != null && !(this.defaultActions instanceof SdkAutoConstructList);
    }

    public List<Action> defaultActions() {
        return this.defaultActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslPolicy(), other.sslPolicy()) && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.defaultActions(), other.defaultActions());
    }

    public String toString() {
        return ToString.builder((String)"CreateListenerRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("SslPolicy", (Object)this.sslPolicy()).add("Certificates", this.certificates()).add("DefaultActions", this.defaultActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SslPolicy": {
                return Optional.ofNullable(clazz.cast(this.sslPolicy()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "DefaultActions": {
                return Optional.ofNullable(clazz.cast(this.defaultActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerRequest, T> g) {
        return obj -> g.apply((CreateListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String protocol;
        private Integer port;
        private String sslPolicy;
        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();
        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.protocol(model.protocol);
            this.port(model.port);
            this.sslPolicy(model.sslPolicy);
            this.certificates(model.certificates);
            this.defaultActions(model.defaultActions);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return this.certificates != null ? (Collection)this.certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (Certificate)((Certificate.Builder)Certificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        public final Collection<Action.Builder> getDefaultActions() {
            return this.defaultActions != null ? (Collection)this.defaultActions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder> ... defaultActions) {
            this.defaultActions(Stream.of(defaultActions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateListenerRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder sslPolicy(String var1);

        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder certificates(Consumer<Certificate.Builder> ... var1);

        public Builder defaultActions(Collection<Action> var1);

        public Builder defaultActions(Action ... var1);

        public Builder defaultActions(Consumer<Action.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

