/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSSLPoliciesResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, DescribeSSLPoliciesResponse> {
    private final List<SslPolicy> sslPolicies;
    private final String nextMarker;

    private DescribeSSLPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.sslPolicies = builder.sslPolicies;
        this.nextMarker = builder.nextMarker;
    }

    public List<SslPolicy> sslPolicies() {
        return this.sslPolicies;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sslPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSSLPoliciesResponse)) {
            return false;
        }
        DescribeSSLPoliciesResponse other = (DescribeSSLPoliciesResponse)((Object)obj);
        return Objects.equals(this.sslPolicies(), other.sslPolicies()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSSLPoliciesResponse").add("SslPolicies", this.sslPolicies()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SslPolicies": {
                return Optional.of(clazz.cast(this.sslPolicies()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<SslPolicy> sslPolicies;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSSLPoliciesResponse model) {
            this.sslPolicies(model.sslPolicies);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<SslPolicy.Builder> getSslPolicies() {
            return this.sslPolicies != null ? (Collection)this.sslPolicies.stream().map(SslPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sslPolicies(Collection<SslPolicy> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copy(sslPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(SslPolicy ... sslPolicies) {
            this.sslPolicies(Arrays.asList(sslPolicies));
            return this;
        }

        public final void setSslPolicies(Collection<SslPolicy.BuilderImpl> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copyFromBuilder(sslPolicies);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeSSLPoliciesResponse build() {
            return new DescribeSSLPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, DescribeSSLPoliciesResponse> {
        public Builder sslPolicies(Collection<SslPolicy> var1);

        public Builder sslPolicies(SslPolicy ... var1);

        public Builder nextMarker(String var1);
    }
}

