/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateListenerRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, CreateListenerRequest> {
    private final String loadBalancerArn;
    private final String protocol;
    private final Integer port;
    private final String sslPolicy;
    private final List<Certificate> certificates;
    private final List<Action> defaultActions;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String sslPolicy() {
        return this.sslPolicy;
    }

    public List<Certificate> certificates() {
        return this.certificates;
    }

    public List<Action> defaultActions() {
        return this.defaultActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.protocolString(), other.protocolString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslPolicy(), other.sslPolicy()) && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.defaultActions(), other.defaultActions());
    }

    public String toString() {
        return ToString.builder((String)"CreateListenerRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Protocol", (Object)this.protocolString()).add("Port", (Object)this.port()).add("SslPolicy", (Object)this.sslPolicy()).add("Certificates", this.certificates()).add("DefaultActions", this.defaultActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.of(clazz.cast(this.loadBalancerArn()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "SslPolicy": {
                return Optional.of(clazz.cast(this.sslPolicy()));
            }
            case "Certificates": {
                return Optional.of(clazz.cast(this.certificates()));
            }
            case "DefaultActions": {
                return Optional.of(clazz.cast(this.defaultActions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String protocol;
        private Integer port;
        private String sslPolicy;
        private List<Certificate> certificates;
        private List<Action> defaultActions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.protocol(model.protocol);
            this.port(model.port);
            this.sslPolicy(model.sslPolicy);
            this.certificates(model.certificates);
            this.defaultActions(model.defaultActions);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return this.certificates != null ? (Collection)this.certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        public final Collection<Action.Builder> getDefaultActions() {
            return this.defaultActions != null ? (Collection)this.defaultActions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultActions(Action ... defaultActions) {
            this.defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, CreateListenerRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder sslPolicy(String var1);

        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder defaultActions(Collection<Action> var1);

        public Builder defaultActions(Action ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

