/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetRulePrioritiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetRulePrioritiesRequest> {
    private final List<RulePriorityPair> rulePriorities;

    private SetRulePrioritiesRequest(BuilderImpl builder) {
        this.rulePriorities = builder.rulePriorities;
    }

    public List<RulePriorityPair> rulePriorities() {
        return this.rulePriorities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rulePriorities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRulePrioritiesRequest)) {
            return false;
        }
        SetRulePrioritiesRequest other = (SetRulePrioritiesRequest)((Object)obj);
        return Objects.equals(this.rulePriorities(), other.rulePriorities());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rulePriorities() != null) {
            sb.append("RulePriorities: ").append(this.rulePriorities()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RulePriorities": {
                return Optional.of(clazz.cast(this.rulePriorities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RulePriorityPair> rulePriorities;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRulePrioritiesRequest model) {
            this.rulePriorities(model.rulePriorities);
        }

        public final Collection<RulePriorityPair.Builder> getRulePriorities() {
            return this.rulePriorities != null ? (Collection)this.rulePriorities.stream().map(RulePriorityPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rulePriorities(Collection<RulePriorityPair> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copy(rulePriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulePriorities(RulePriorityPair ... rulePriorities) {
            this.rulePriorities(Arrays.asList(rulePriorities));
            return this;
        }

        public final void setRulePriorities(Collection<RulePriorityPair.BuilderImpl> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copyFromBuilder(rulePriorities);
        }

        public SetRulePrioritiesRequest build() {
            return new SetRulePrioritiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetRulePrioritiesRequest> {
        public Builder rulePriorities(Collection<RulePriorityPair> var1);

        public Builder rulePriorities(RulePriorityPair ... var1);
    }
}

