/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerState
implements ToCopyableBuilder<Builder, LoadBalancerState> {
    private final String code;
    private final String reason;

    private LoadBalancerState(BuilderImpl builder) {
        this.code = builder.code;
        this.reason = builder.reason;
    }

    public LoadBalancerStateEnum code() {
        return LoadBalancerStateEnum.fromValue(this.code);
    }

    public String codeString() {
        return this.code;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerState)) {
            return false;
        }
        LoadBalancerState other = (LoadBalancerState)obj;
        return Objects.equals(this.codeString(), other.codeString()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.codeString() != null) {
            sb.append("Code: ").append(this.codeString()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.of(clazz.cast(this.codeString()));
            }
            case "Reason": {
                return Optional.of(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerState model) {
            this.code(model.code);
            this.reason(model.reason);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(LoadBalancerStateEnum code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public LoadBalancerState build() {
            return new LoadBalancerState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerState> {
        public Builder code(String var1);

        public Builder code(LoadBalancerStateEnum var1);

        public Builder reason(String var1);
    }
}

