/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;

public class SetSubnetsRequestMarshaller
implements Marshaller<Request<SetSubnetsRequest>, SetSubnetsRequest> {
    public Request<SetSubnetsRequest> marshall(SetSubnetsRequest setSubnetsRequest) {
        List<String> subnetsList;
        if (setSubnetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSubnetsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "SetSubnets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSubnetsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)setSubnetsRequest.loadBalancerArn()));
        }
        if ((subnetsList = setSubnetsRequest.subnets()) != null) {
            if (!subnetsList.isEmpty()) {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            } else {
                request.addParameter("Subnets", "");
            }
        }
        return request;
    }
}

