/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;

public class DescribeAccountLimitsRequestMarshaller
implements Marshaller<Request<DescribeAccountLimitsRequest>, DescribeAccountLimitsRequest> {
    public Request<DescribeAccountLimitsRequest> marshall(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        if (describeAccountLimitsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAccountLimitsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeAccountLimits");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAccountLimitsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeAccountLimitsRequest.marker()));
        }
        if (describeAccountLimitsRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeAccountLimitsRequest.pageSize()));
        }
        return request;
    }
}

