/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyTargetGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyTargetGroupRequest> {
    private final String targetGroupArn;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final Matcher matcher;

    private ModifyTargetGroupRequest(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroupArn() == null ? 0 : this.targetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckProtocolString() == null ? 0 : this.healthCheckProtocolString().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckPort() == null ? 0 : this.healthCheckPort().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckPath() == null ? 0 : this.healthCheckPath().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckIntervalSeconds() == null ? 0 : this.healthCheckIntervalSeconds().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckTimeoutSeconds() == null ? 0 : this.healthCheckTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.healthyThresholdCount() == null ? 0 : this.healthyThresholdCount().hashCode());
        hashCode = 31 * hashCode + (this.unhealthyThresholdCount() == null ? 0 : this.unhealthyThresholdCount().hashCode());
        hashCode = 31 * hashCode + (this.matcher() == null ? 0 : this.matcher().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupRequest)) {
            return false;
        }
        ModifyTargetGroupRequest other = (ModifyTargetGroupRequest)((Object)obj);
        if (other.targetGroupArn() == null ^ this.targetGroupArn() == null) {
            return false;
        }
        if (other.targetGroupArn() != null && !other.targetGroupArn().equals(this.targetGroupArn())) {
            return false;
        }
        if (other.healthCheckProtocolString() == null ^ this.healthCheckProtocolString() == null) {
            return false;
        }
        if (other.healthCheckProtocolString() != null && !other.healthCheckProtocolString().equals(this.healthCheckProtocolString())) {
            return false;
        }
        if (other.healthCheckPort() == null ^ this.healthCheckPort() == null) {
            return false;
        }
        if (other.healthCheckPort() != null && !other.healthCheckPort().equals(this.healthCheckPort())) {
            return false;
        }
        if (other.healthCheckPath() == null ^ this.healthCheckPath() == null) {
            return false;
        }
        if (other.healthCheckPath() != null && !other.healthCheckPath().equals(this.healthCheckPath())) {
            return false;
        }
        if (other.healthCheckIntervalSeconds() == null ^ this.healthCheckIntervalSeconds() == null) {
            return false;
        }
        if (other.healthCheckIntervalSeconds() != null && !other.healthCheckIntervalSeconds().equals(this.healthCheckIntervalSeconds())) {
            return false;
        }
        if (other.healthCheckTimeoutSeconds() == null ^ this.healthCheckTimeoutSeconds() == null) {
            return false;
        }
        if (other.healthCheckTimeoutSeconds() != null && !other.healthCheckTimeoutSeconds().equals(this.healthCheckTimeoutSeconds())) {
            return false;
        }
        if (other.healthyThresholdCount() == null ^ this.healthyThresholdCount() == null) {
            return false;
        }
        if (other.healthyThresholdCount() != null && !other.healthyThresholdCount().equals(this.healthyThresholdCount())) {
            return false;
        }
        if (other.unhealthyThresholdCount() == null ^ this.unhealthyThresholdCount() == null) {
            return false;
        }
        if (other.unhealthyThresholdCount() != null && !other.unhealthyThresholdCount().equals(this.unhealthyThresholdCount())) {
            return false;
        }
        if (other.matcher() == null ^ this.matcher() == null) {
            return false;
        }
        return other.matcher() == null || other.matcher().equals(this.matcher());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.targetGroupArn()).append(",");
        }
        if (this.healthCheckProtocolString() != null) {
            sb.append("HealthCheckProtocol: ").append(this.healthCheckProtocolString()).append(",");
        }
        if (this.healthCheckPort() != null) {
            sb.append("HealthCheckPort: ").append(this.healthCheckPort()).append(",");
        }
        if (this.healthCheckPath() != null) {
            sb.append("HealthCheckPath: ").append(this.healthCheckPath()).append(",");
        }
        if (this.healthCheckIntervalSeconds() != null) {
            sb.append("HealthCheckIntervalSeconds: ").append(this.healthCheckIntervalSeconds()).append(",");
        }
        if (this.healthCheckTimeoutSeconds() != null) {
            sb.append("HealthCheckTimeoutSeconds: ").append(this.healthCheckTimeoutSeconds()).append(",");
        }
        if (this.healthyThresholdCount() != null) {
            sb.append("HealthyThresholdCount: ").append(this.healthyThresholdCount()).append(",");
        }
        if (this.unhealthyThresholdCount() != null) {
            sb.append("UnhealthyThresholdCount: ").append(this.unhealthyThresholdCount()).append(",");
        }
        if (this.matcher() != null) {
            sb.append("Matcher: ").append(this.matcher()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "HealthCheckProtocol": {
                return Optional.of(clazz.cast(this.healthCheckProtocolString()));
            }
            case "HealthCheckPort": {
                return Optional.of(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckPath": {
                return Optional.of(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.of(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.of(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.of(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.of(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "Matcher": {
                return Optional.of(clazz.cast(this.matcher()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private Matcher matcher;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupRequest model) {
            this.targetGroupArn(model.targetGroupArn);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.matcher(model.matcher);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public ModifyTargetGroupRequest build() {
            return new ModifyTargetGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyTargetGroupRequest> {
        public Builder targetGroupArn(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder matcher(Matcher var1);
    }
}

