/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateListenerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateListenerResponse> {
    private final List<Listener> listeners;

    private CreateListenerResponse(BuilderImpl builder) {
        this.listeners = builder.listeners;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.listeners() == null ? 0 : this.listeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerResponse)) {
            return false;
        }
        CreateListenerResponse other = (CreateListenerResponse)((Object)obj);
        if (other.listeners() == null ^ this.listeners() == null) {
            return false;
        }
        return other.listeners() == null || other.listeners().equals(this.listeners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Listeners": {
                return Optional.of(clazz.cast(this.listeners()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Listener> listeners;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerResponse model) {
            this.listeners(model.listeners);
        }

        public final Collection<Listener.Builder> getListeners() {
            return this.listeners != null ? (Collection)this.listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        public CreateListenerResponse build() {
            return new CreateListenerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateListenerResponse> {
        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);
    }
}

