/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.util.StringUtils;

public class ModifyTargetGroupAttributesRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupAttributesRequest>, ModifyTargetGroupAttributesRequest> {
    public Request<ModifyTargetGroupAttributesRequest> marshall(ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        List<TargetGroupAttribute> attributesList;
        if (modifyTargetGroupAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyTargetGroupAttributesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "ModifyTargetGroupAttributes");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupAttributesRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)modifyTargetGroupAttributesRequest.targetGroupArn()));
        }
        if ((attributesList = modifyTargetGroupAttributesRequest.attributes()) != null) {
            if (!attributesList.isEmpty()) {
                int attributesListIndex = 1;
                for (TargetGroupAttribute attributesListValue : attributesList) {
                    if (attributesListValue.key() != null) {
                        request.addParameter("Attributes.member." + attributesListIndex + ".Key", StringUtils.fromString((String)attributesListValue.key()));
                    }
                    if (attributesListValue.value() != null) {
                        request.addParameter("Attributes.member." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.value()));
                    }
                    ++attributesListIndex;
                }
            } else {
                request.addParameter("Attributes", "");
            }
        }
        return request;
    }
}

