/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeTargetGroupsRequest> {
    private final String loadBalancerArn;
    private final List<String> targetGroupArns;
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeTargetGroupsRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.targetGroupArns = builder.targetGroupArns;
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<String> targetGroupArns() {
        return this.targetGroupArns;
    }

    public List<String> names() {
        return this.names;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArn() == null ? 0 : this.loadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.targetGroupArns() == null ? 0 : this.targetGroupArns().hashCode());
        hashCode = 31 * hashCode + (this.names() == null ? 0 : this.names().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsRequest)) {
            return false;
        }
        DescribeTargetGroupsRequest other = (DescribeTargetGroupsRequest)((Object)obj);
        if (other.loadBalancerArn() == null ^ this.loadBalancerArn() == null) {
            return false;
        }
        if (other.loadBalancerArn() != null && !other.loadBalancerArn().equals(this.loadBalancerArn())) {
            return false;
        }
        if (other.targetGroupArns() == null ^ this.targetGroupArns() == null) {
            return false;
        }
        if (other.targetGroupArns() != null && !other.targetGroupArns().equals(this.targetGroupArns())) {
            return false;
        }
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.targetGroupArns() != null) {
            sb.append("TargetGroupArns: ").append(this.targetGroupArns()).append(",");
        }
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> targetGroupArns;
        private List<String> names;
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsRequest model) {
            this.setLoadBalancerArn(model.loadBalancerArn);
            this.setTargetGroupArns(model.targetGroupArns);
            this.setNames(model.names);
            this.setMarker(model.marker);
            this.setPageSize(model.pageSize);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<String> getTargetGroupArns() {
            return this.targetGroupArns;
        }

        @Override
        public final Builder targetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupArns(String ... targetGroupArns) {
            this.targetGroupArns(Arrays.asList(targetGroupArns));
            return this;
        }

        public final void setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = TargetGroupArnsCopier.copy(targetGroupArns);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = TargetGroupNamesCopier.copy(names);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeTargetGroupsRequest build() {
            return new DescribeTargetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTargetGroupsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder targetGroupArns(Collection<String> var1);

        public Builder targetGroupArns(String ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);
    }
}

