/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetHealthDescription
implements ToCopyableBuilder<Builder, TargetHealthDescription> {
    private final TargetDescription target;
    private final String healthCheckPort;
    private final TargetHealth targetHealth;

    private TargetHealthDescription(BuilderImpl builder) {
        this.target = builder.target;
        this.healthCheckPort = builder.healthCheckPort;
        this.targetHealth = builder.targetHealth;
    }

    public TargetDescription target() {
        return this.target;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public TargetHealth targetHealth() {
        return this.targetHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.target() == null ? 0 : this.target().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckPort() == null ? 0 : this.healthCheckPort().hashCode());
        hashCode = 31 * hashCode + (this.targetHealth() == null ? 0 : this.targetHealth().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealthDescription)) {
            return false;
        }
        TargetHealthDescription other = (TargetHealthDescription)obj;
        if (other.target() == null ^ this.target() == null) {
            return false;
        }
        if (other.target() != null && !other.target().equals(this.target())) {
            return false;
        }
        if (other.healthCheckPort() == null ^ this.healthCheckPort() == null) {
            return false;
        }
        if (other.healthCheckPort() != null && !other.healthCheckPort().equals(this.healthCheckPort())) {
            return false;
        }
        if (other.targetHealth() == null ^ this.targetHealth() == null) {
            return false;
        }
        return other.targetHealth() == null || other.targetHealth().equals(this.targetHealth());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.target() != null) {
            sb.append("Target: ").append(this.target()).append(",");
        }
        if (this.healthCheckPort() != null) {
            sb.append("HealthCheckPort: ").append(this.healthCheckPort()).append(",");
        }
        if (this.targetHealth() != null) {
            sb.append("TargetHealth: ").append(this.targetHealth()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private TargetDescription target;
        private String healthCheckPort;
        private TargetHealth targetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealthDescription model) {
            this.setTarget(model.target);
            this.setHealthCheckPort(model.healthCheckPort);
            this.setTargetHealth(model.targetHealth);
        }

        public final TargetDescription getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(TargetDescription target) {
            this.target = target;
            return this;
        }

        public final void setTarget(TargetDescription target) {
            this.target = target;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final TargetHealth getTargetHealth() {
            return this.targetHealth;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final void setTargetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
        }

        public TargetHealthDescription build() {
            return new TargetHealthDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetHealthDescription> {
        public Builder target(TargetDescription var1);

        public Builder healthCheckPort(String var1);

        public Builder targetHealth(TargetHealth var1);
    }
}

