/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyListenerRequestMarshaller
implements Marshaller<Request<ModifyListenerRequest>, ModifyListenerRequest> {
    public Request<ModifyListenerRequest> marshall(ModifyListenerRequest modifyListenerRequest) {
        List<Action> defaultActionsList;
        List<Certificate> certificatesList;
        if (modifyListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyListenerRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "ModifyListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyListenerRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)modifyListenerRequest.listenerArn()));
        }
        if (modifyListenerRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)modifyListenerRequest.port()));
        }
        if (modifyListenerRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)modifyListenerRequest.protocol()));
        }
        if (modifyListenerRequest.sslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)modifyListenerRequest.sslPolicy()));
        }
        if ((certificatesList = modifyListenerRequest.certificates()) != null) {
            if (!certificatesList.isEmpty()) {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.certificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.certificateArn()));
                    }
                    ++certificatesListIndex;
                }
            } else {
                request.addParameter("Certificates", "");
            }
        }
        if ((defaultActionsList = modifyListenerRequest.defaultActions()) != null) {
            if (!defaultActionsList.isEmpty()) {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue.type() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.type()));
                    }
                    if (defaultActionsListValue.targetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.targetGroupArn()));
                    }
                    ++defaultActionsListIndex;
                }
            } else {
                request.addParameter("DefaultActions", "");
            }
        }
        return request;
    }
}

