/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        List<Action> defaultActionsList;
        List<Certificate> certificatesList;
        if (createListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createListenerRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)createListenerRequest.loadBalancerArn()));
        }
        if (createListenerRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createListenerRequest.protocol()));
        }
        if (createListenerRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createListenerRequest.port()));
        }
        if (createListenerRequest.sslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)createListenerRequest.sslPolicy()));
        }
        if ((certificatesList = createListenerRequest.certificates()) != null) {
            if (!certificatesList.isEmpty()) {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.certificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.certificateArn()));
                    }
                    ++certificatesListIndex;
                }
            } else {
                request.addParameter("Certificates", "");
            }
        }
        if ((defaultActionsList = createListenerRequest.defaultActions()) != null) {
            if (!defaultActionsList.isEmpty()) {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue.type() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.type()));
                    }
                    if (defaultActionsListValue.targetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.targetGroupArn()));
                    }
                    ++defaultActionsListIndex;
                }
            } else {
                request.addParameter("DefaultActions", "");
            }
        }
        return request;
    }
}

