/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancersRequest> {
    private final List<String> loadBalancerArns;
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeLoadBalancersRequest(BuilderImpl builder) {
        this.loadBalancerArns = builder.loadBalancerArns;
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public List<String> loadBalancerArns() {
        return this.loadBalancerArns;
    }

    public List<String> names() {
        return this.names;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArns() == null ? 0 : this.loadBalancerArns().hashCode());
        hashCode = 31 * hashCode + (this.names() == null ? 0 : this.names().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersRequest)) {
            return false;
        }
        DescribeLoadBalancersRequest other = (DescribeLoadBalancersRequest)((Object)obj);
        if (other.loadBalancerArns() == null ^ this.loadBalancerArns() == null) {
            return false;
        }
        if (other.loadBalancerArns() != null && !other.loadBalancerArns().equals(this.loadBalancerArns())) {
            return false;
        }
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArns() != null) {
            sb.append("LoadBalancerArns: ").append(this.loadBalancerArns()).append(",");
        }
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> loadBalancerArns;
        private List<String> names;
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersRequest model) {
            this.setLoadBalancerArns(model.loadBalancerArns);
            this.setNames(model.names);
            this.setMarker(model.marker);
            this.setPageSize(model.pageSize);
        }

        public final Collection<String> getLoadBalancerArns() {
            return this.loadBalancerArns;
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        @SafeVarargs
        public final void setLoadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = LoadBalancerNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = LoadBalancerNamesCopier.copy(names);
        }

        @SafeVarargs
        public final void setNames(String ... names) {
            this.names(Arrays.asList(names));
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeLoadBalancersRequest build() {
            return new DescribeLoadBalancersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersRequest> {
        public Builder loadBalancerArns(Collection<String> var1);

        public Builder loadBalancerArns(String ... var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);
    }
}

